/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.iid.zzau;
import com.google.firebase.iid.zzi;
import javax.annotation.concurrent.GuardedBy;

public final class FirebaseInstanceIdReceiver
extends WakefulBroadcastReceiver {
    private static boolean zzbl = false;
    @GuardedBy(value="FirebaseInstanceIdReceiver.class")
    private static zzi zzbm;
    @GuardedBy(value="FirebaseInstanceIdReceiver.class")
    private static zzi zzbn;

    public final void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        Parcelable parcelable = intent.getParcelableExtra("wrapped_intent");
        Intent intent2 = parcelable instanceof Intent ? (Intent)parcelable : null;
        if (intent2 != null) {
            this.zza(context, intent2, intent.getAction());
            return;
        }
        this.zza(context, intent, intent.getAction());
    }

    private final void zza(Context context, Intent intent, String string) {
        String string2;
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        if ((string2 = intent.getStringExtra("gcm.rawData64")) != null) {
            intent.putExtra("rawData", Base64.decode((String)string2, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        String string3 = null;
        String string4 = intent.getStringExtra("from");
        if ("google.com/iid".equals(string4) || "com.google.firebase.INSTANCE_ID_EVENT".equals(string)) {
            string3 = "com.google.firebase.INSTANCE_ID_EVENT";
        } else if ("com.google.android.c2dm.intent.RECEIVE".equals(string) || "com.google.firebase.MESSAGING_EVENT".equals(string)) {
            string3 = "com.google.firebase.MESSAGING_EVENT";
        } else {
            Log.d((String)"FirebaseInstanceId", (String)"Unexpected intent");
        }
        int n = -1;
        if (string3 != null) {
            n = FirebaseInstanceIdReceiver.zza((BroadcastReceiver)this, context, string3, intent);
        }
        if (this.isOrderedBroadcast()) {
            this.setResultCode(n);
        }
    }

    @ShowFirstParty
    @SuppressLint(value={"InlinedApi"})
    public static int zza(BroadcastReceiver broadcastReceiver, Context context, String string, Intent intent) {
        boolean bl;
        boolean bl2 = PlatformVersion.isAtLeastO() && context.getApplicationInfo().targetSdkVersion >= 26;
        boolean bl3 = bl = (intent.getFlags() & 0x10000000) != 0;
        if (bl2 && !bl) {
            return FirebaseInstanceIdReceiver.zzb(broadcastReceiver, context, string, intent);
        }
        int n = zzau.zzai().zzb(context, string, intent);
        if (PlatformVersion.isAtLeastO() && n == 402) {
            FirebaseInstanceIdReceiver.zzb(broadcastReceiver, context, string, intent);
            return 403;
        }
        return n;
    }

    private static int zzb(BroadcastReceiver broadcastReceiver, Context context, String string, Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Binding to service: ".concat(string2) : new String("Binding to service: ")));
        }
        if (broadcastReceiver.isOrderedBroadcast()) {
            broadcastReceiver.setResultCode(-1);
        }
        FirebaseInstanceIdReceiver.zza(context, string).zza(intent, broadcastReceiver.goAsync());
        return -1;
    }

    private static synchronized zzi zza(Context context, String string) {
        if ("com.google.firebase.MESSAGING_EVENT".equals(string)) {
            if (zzbn == null) {
                zzbn = new zzi(context, string);
            }
            return zzbn;
        }
        if (zzbm == null) {
            zzbm = new zzi(context, string);
        }
        return zzbm;
    }
}

