/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.MessagingChannel;
import com.google.firebase.iid.zzam;
import com.google.firebase.iid.zzar;
import com.google.firebase.iid.zzaw;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzaz;
import com.google.firebase.iid.zzba;
import com.google.firebase.iid.zzh;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzy;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zzaq = TimeUnit.HOURS.toSeconds(8L);
    private static zzax zzar;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledThreadPoolExecutor zzas;
    private final Executor zzat;
    private final FirebaseApp zzau;
    private final zzam zzav;
    private MessagingChannel zzaw;
    private final zzar zzax;
    private final zzba zzay;
    @GuardedBy(value="this")
    private boolean zzaz = false;
    private final zza zzba;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Subscriber subscriber, UserAgentPublisher userAgentPublisher) {
        this(firebaseApp, new zzam(firebaseApp.getApplicationContext()), zzh.zze(), zzh.zze(), subscriber, userAgentPublisher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzam zzam2, Executor executor, Executor executor2, Subscriber subscriber, UserAgentPublisher userAgentPublisher) {
        if (zzam.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzar == null) {
                zzar = new zzax(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this.zzau = firebaseApp;
            this.zzav = zzam2;
            UserAgentPublisher userAgentPublisher2 = userAgentPublisher;
            Executor executor3 = executor;
            zzam zzam3 = zzam2;
            FirebaseApp firebaseApp2 = firebaseApp;
            FirebaseInstanceId firebaseInstanceId = this;
            if (firebaseInstanceId.zzaw == null) {
                MessagingChannel messagingChannel = (MessagingChannel)firebaseApp2.get(MessagingChannel.class);
                firebaseInstanceId.zzaw = messagingChannel != null && messagingChannel.isAvailable() ? messagingChannel : new zzr(firebaseApp2, zzam3, executor3, userAgentPublisher2);
            }
            this.zzaw = firebaseInstanceId.zzaw;
            this.zzat = executor2;
            this.zzay = new zzba(zzar);
            this.zzba = new zza(subscriber);
            this.zzax = new zzar(executor);
            if (this.zzba.isEnabled()) {
                this.zzh();
            }
            return;
        }
    }

    private final void zzh() {
        zzaw zzaw2 = this.zzk();
        if (this.zzr() || this.zza(zzaw2) || this.zzay.zzaq()) {
            this.startSync();
        }
    }

    final FirebaseApp zzi() {
        return this.zzau;
    }

    final synchronized void zza(boolean bl) {
        this.zzaz = bl;
    }

    private final synchronized void startSync() {
        if (!this.zzaz) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zzaq);
        FirebaseInstanceId.zza(new zzaz(this, this.zzav, this.zzay, l2), l);
        this.zzaz = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzas == null) {
                zzas = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("FirebaseInstanceId"));
            }
            zzas.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzh();
        return FirebaseInstanceId.zzj();
    }

    private static String zzj() {
        return zzam.zza(zzar.zzi("").getKeyPair());
    }

    public long getCreationTime() {
        return zzar.zzi("").getCreationTime();
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        return this.zza(zzam.zza(this.zzau), "*");
    }

    private final Task<InstanceIdResult> zza(String string, String string2) {
        String string3 = FirebaseInstanceId.zzd(string2);
        return Tasks.forResult(null).continueWithTask(this.zzat, (Continuation)new zzo(this, string, string3));
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        String string = FirebaseInstanceId.zzj();
        this.zza(this.zzaw.deleteInstanceId(string));
        this.zzn();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        zzaw zzaw2 = this.zzk();
        if (this.zzaw.needsRefresh() || this.zza(zzaw2)) {
            this.startSync();
        }
        return com.google.firebase.iid.zzaw.zzb(zzaw2);
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.zza(this.zza(string, string2)).getToken();
    }

    @Nullable
    final zzaw zzk() {
        return FirebaseInstanceId.zzb(zzam.zza(this.zzau), "*");
    }

    @Nullable
    @VisibleForTesting
    private static zzaw zzb(String string, String string2) {
        return zzar.zzb("", string, string2);
    }

    final String zzl() throws IOException {
        return this.getToken(zzam.zza(this.zzau), "*");
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zzn();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        String string3 = FirebaseInstanceId.zzj();
        String string4 = com.google.firebase.iid.zzaw.zzb(FirebaseInstanceId.zzb(string, string2));
        this.zza(this.zzaw.deleteToken(string3, string4, string, string2));
        zzar.zzc("", string, string2);
    }

    public final synchronized Task<Void> zza(String string) {
        Task<Void> task = this.zzay.zza(string);
        this.startSync();
        return task;
    }

    final void zzb(String string) throws IOException {
        zzaw zzaw2 = this.zzk();
        if (this.zza(zzaw2)) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzj();
        String string3 = string;
        String string4 = zzaw2.zzbx;
        String string5 = string2;
        Task<Void> task = this.zzaw.subscribeToTopic(string5, string4, string3);
        this.zza(task);
    }

    final void zzc(String string) throws IOException {
        zzaw zzaw2 = this.zzk();
        if (this.zza(zzaw2)) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzj();
        this.zza(this.zzaw.unsubscribeFromTopic(string2, zzaw2.zzbx, string));
    }

    static boolean zzm() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zzn() {
        zzar.zzal();
        if (this.zzba.isEnabled()) {
            this.startSync();
        }
    }

    final boolean zzo() {
        return this.zzaw.isAvailable();
    }

    final void zzp() {
        zzar.zzj("");
        this.startSync();
    }

    @VisibleForTesting
    public final boolean zzq() {
        return this.zzba.isEnabled();
    }

    @VisibleForTesting
    public final void zzb(boolean bl) {
        this.zzba.setEnabled(bl);
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final boolean zza(@Nullable zzaw zzaw2) {
        return zzaw2 == null || zzaw2.zzg(this.zzav.zzad());
    }

    final boolean zzr() {
        return this.zzaw.needsRefresh();
    }

    final /* synthetic */ Task zza(String string, String string2, Task task) throws Exception {
        String string3 = FirebaseInstanceId.zzj();
        zzaw zzaw2 = FirebaseInstanceId.zzb(string, string2);
        if (!this.zzaw.needsRefresh() && !this.zza(zzaw2)) {
            return Tasks.forResult((Object)new zzy(string3, zzaw2.zzbx));
        }
        String string4 = com.google.firebase.iid.zzaw.zzb(zzaw2);
        return this.zzax.zza(string, string2, new zzn(this, string3, string4, string, string2));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3, String string4) {
        return this.zzaw.getToken(string, string2, string3, string4).onSuccessTask(this.zzat, (SuccessContinuation)new zzp(this, string3, string4, string));
    }

    final /* synthetic */ Task zzb(String string, String string2, String string3, String string4) throws Exception {
        zzar.zza("", string, string2, string4, this.zzav.zzad());
        return Tasks.forResult((Object)new zzy(string3, string4));
    }

    private final class zza {
        private final boolean zzbg;
        private final Subscriber zzbh;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> zzbi;
        @GuardedBy(value="this")
        @Nullable
        private Boolean zzbj;

        zza(Subscriber subscriber) {
            this.zzbh = subscriber;
            this.zzbg = this.zzu();
            this.zzbj = this.zzt();
            if (this.zzbj == null && this.zzbg) {
                this.zzbi = new zzq(this);
                subscriber.subscribe(DataCollectionDefaultChange.class, this.zzbi);
            }
        }

        final synchronized boolean isEnabled() {
            if (this.zzbj != null) {
                return this.zzbj;
            }
            return this.zzbg && FirebaseInstanceId.this.zzau.isDataCollectionDefaultEnabled();
        }

        final synchronized void setEnabled(boolean bl) {
            if (this.zzbi != null) {
                this.zzbh.unsubscribe(DataCollectionDefaultChange.class, this.zzbi);
                this.zzbi = null;
            }
            SharedPreferences.Editor editor = FirebaseInstanceId.this.zzau.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseInstanceId.this.zzh();
            }
            this.zzbj = bl;
        }

        @Nullable
        private final Boolean zzt() {
            Context context = FirebaseInstanceId.this.zzau.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        private final boolean zzu() {
            try {
                Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Context context = FirebaseInstanceId.this.zzau.getApplicationContext();
                Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
                intent.setPackage(context.getPackageName());
                ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
                return resolveInfo != null && resolveInfo.serviceInfo != null;
            }
        }
    }
}

