/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.firebase_messaging.zza;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzaf;
import com.google.firebase.iid.zzag;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzak;
import com.google.firebase.iid.zzal;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzad
implements ServiceConnection {
    @GuardedBy(value="this")
    int state = 0;
    final Messenger zzbx = new Messenger((Handler)new zza(Looper.getMainLooper(), new zzae(this)));
    zzai zzby;
    @GuardedBy(value="this")
    final Queue<zzak<?>> zzbz = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzak<?>> zzca = new SparseArray();
    final /* synthetic */ zzab zzcb;

    private zzad(zzab zzab2) {
        this.zzcb = zzab2;
    }

    final synchronized boolean zzb(zzak zzak2) {
        switch (this.state) {
            case 0: {
                this.zzbz.add(zzak2);
                zzad zzad2 = this;
                Preconditions.checkState((zzad2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzad2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzab.zza(zzad2.zzcb), intent, (ServiceConnection)zzad2, 1)) {
                    zzad2.zza(0, "Unable to bind to service");
                } else {
                    zzab.zzb(zzad2.zzcb).schedule(new zzaf(zzad2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzbz.add(zzak2);
                return true;
            }
            case 2: {
                this.zzbz.add(zzak2);
                this.zzy();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzak zzak2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzad zzad2 = this;
        synchronized (zzad2) {
            zzak2 = (zzak)this.zzca.get(n);
            if (zzak2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zzca.remove(n);
            this.zzz();
        }
        Bundle bundle = message.getData();
        zzak zzak3 = zzak2;
        if (bundle.getBoolean("unsupported", false)) {
            zzak3.zza(new zzal(4, "Not supported by GmsCore"));
        } else {
            zzak3.zzb(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zza(0, "Null service connection");
            return;
        }
        try {
            this.zzby = new zzai(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zza(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzy();
    }

    private final void zzy() {
        zzab.zzb(this.zzcb).execute(new zzag(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zza(2, "Service disconnected");
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                ConnectionTracker.getInstance().unbindService(zzab.zza(this.zzcb), (ServiceConnection)this);
                zzal zzal2 = new zzal(n, string);
                zzad zzad2 = this;
                Iterator iterator = zzad2.zzbz.iterator();
                while (iterator.hasNext()) {
                    ((zzak)iterator.next()).zza(zzal2);
                }
                zzad2.zzbz.clear();
                for (int i = 0; i < zzad2.zzca.size(); ++i) {
                    ((zzak)zzad2.zzca.valueAt(i)).zza(zzal2);
                }
                zzad2.zzca.clear();
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzz() {
        if (this.state == 2 && this.zzbz.isEmpty() && this.zzca.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            ConnectionTracker.getInstance().unbindService(zzab.zza(this.zzcb), (ServiceConnection)this);
        }
    }

    final synchronized void zzaa() {
        if (this.state == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzak zzak2 = (zzak)this.zzca.get(n);
        if (zzak2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zzca.remove(n);
            zzak2.zza(new zzal(3, "Timed out waiting for response"));
            this.zzz();
        }
    }

    /* synthetic */ zzad(zzab zzab2, zzac zzac2) {
        this(zzab2);
    }
}

