/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.MessagingChannel;
import com.google.firebase.iid.zzan;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzaw;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzay;
import com.google.firebase.iid.zzba;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzx;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zzai = TimeUnit.HOURS.toSeconds(8L);
    private static zzaw zzaj;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledThreadPoolExecutor zzak;
    private final Executor zzal;
    private final FirebaseApp zzam;
    private final zzan zzan;
    private MessagingChannel zzao;
    private final zzaq zzap;
    private final zzba zzaq;
    @GuardedBy(value="this")
    private boolean zzar = false;
    private final zza zzas;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Subscriber subscriber) {
        this(firebaseApp, new zzan(firebaseApp.getApplicationContext()), zzi.zzf(), zzi.zzf(), subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzan zzan2, Executor executor, Executor executor2, Subscriber subscriber) {
        if (com.google.firebase.iid.zzan.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzaj == null) {
                zzaj = new zzaw(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.zzam = firebaseApp;
            this.zzan = zzan2;
            Executor executor3 = executor;
            zzan zzan3 = zzan2;
            FirebaseApp firebaseApp2 = firebaseApp;
            FirebaseInstanceId firebaseInstanceId = this;
            if (firebaseInstanceId.zzao == null) {
                MessagingChannel messagingChannel = (MessagingChannel)firebaseApp2.get(MessagingChannel.class);
                firebaseInstanceId.zzao = messagingChannel != null && messagingChannel.isAvailable() ? messagingChannel : new zzr(firebaseApp2, zzan3, executor3);
            }
            this.zzao = firebaseInstanceId.zzao;
            this.zzal = executor2;
            this.zzaq = new zzba(zzaj);
            this.zzas = new zza(subscriber);
            this.zzap = new zzaq(executor);
            if (this.zzas.isEnabled()) {
                this.zzg();
            }
            return;
        }
    }

    private final void zzg() {
        zzax zzax2 = this.zzj();
        if (!this.zzo() || zzax2 == null || zzax2.zzj(this.zzan.zzad()) || this.zzaq.zzaq()) {
            this.startSync();
        }
    }

    final FirebaseApp zzh() {
        return this.zzam;
    }

    final synchronized void zza(boolean bl) {
        this.zzar = bl;
    }

    private final synchronized void startSync() {
        if (!this.zzar) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zzai);
        FirebaseInstanceId.zza(new zzay(this, this.zzan, this.zzaq, l2), l);
        this.zzar = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzak == null) {
                zzak = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("FirebaseInstanceId"));
            }
            zzak.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzg();
        return FirebaseInstanceId.zzi();
    }

    private static String zzi() {
        return com.google.firebase.iid.zzan.zza(zzaj.zzg("").getKeyPair());
    }

    public long getCreationTime() {
        return zzaj.zzg("").getCreationTime();
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        return this.zza(com.google.firebase.iid.zzan.zza(this.zzam), "*");
    }

    private final Task<InstanceIdResult> zza(String string, String string2) {
        String string3 = FirebaseInstanceId.zzd(string2);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzal.execute(new zzn(this, string, string2, taskCompletionSource, string3));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        String string = FirebaseInstanceId.zzi();
        this.zza(this.zzao.deleteInstanceId(string));
        this.zzm();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        zzax zzax2 = this.zzj();
        if (zzax2 == null || zzax2.zzj(this.zzan.zzad())) {
            this.startSync();
        }
        if (zzax2 != null) {
            return zzax2.zzbq;
        }
        return null;
    }

    @Nullable
    final zzax zzj() {
        return FirebaseInstanceId.zzb(com.google.firebase.iid.zzan.zza(this.zzam), "*");
    }

    @Nullable
    @VisibleForTesting
    private static zzax zzb(String string, String string2) {
        return zzaj.zzb("", string, string2);
    }

    final String zzk() throws IOException {
        return this.getToken(com.google.firebase.iid.zzan.zza(this.zzam), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.zza(this.zza(string, string2)).getToken();
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zzm();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        String string3 = FirebaseInstanceId.zzi();
        String string4 = zzax.zza(FirebaseInstanceId.zzb(string, string2));
        this.zza(this.zzao.deleteToken(string3, string4, string, string2));
        zzaj.zzc("", string, string2);
    }

    public final synchronized Task<Void> zza(String string) {
        Task<Void> task = this.zzaq.zza(string);
        this.startSync();
        return task;
    }

    final void zzb(String string) throws IOException {
        zzax zzax2 = this.zzj();
        if (zzax2 == null || zzax2.zzj(this.zzan.zzad())) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzi();
        String string3 = string;
        String string4 = zzax2.zzbq;
        String string5 = string2;
        Task<Void> task = this.zzao.subscribeToTopic(string5, string4, string3);
        this.zza(task);
    }

    final void zzc(String string) throws IOException {
        zzax zzax2 = this.zzj();
        if (zzax2 == null || zzax2.zzj(this.zzan.zzad())) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzi();
        this.zza(this.zzao.unsubscribeFromTopic(string2, zzax2.zzbq, string));
    }

    static boolean zzl() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zzm() {
        zzaj.zzal();
        if (this.zzas.isEnabled()) {
            this.startSync();
        }
    }

    final boolean zzn() {
        return this.zzao.isAvailable();
    }

    final boolean zzo() {
        return this.zzao.isChannelBuilt();
    }

    final void zzp() throws IOException {
        String string = FirebaseInstanceId.zzi();
        String string2 = zzax.zza(this.zzj());
        this.zza(this.zzao.buildChannel(string, string2));
    }

    final void zzq() {
        zzaj.zzh("");
        this.startSync();
    }

    @VisibleForTesting
    public final boolean zzr() {
        return this.zzas.isEnabled();
    }

    @VisibleForTesting
    public final void zzb(boolean bl) {
        this.zzas.setEnabled(bl);
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final /* synthetic */ void zza(String string, String string2, TaskCompletionSource taskCompletionSource, String string3) {
        String string4 = FirebaseInstanceId.zzi();
        zzax zzax2 = FirebaseInstanceId.zzb(string, string2);
        if (zzax2 != null && !zzax2.zzj(this.zzan.zzad())) {
            taskCompletionSource.setResult((Object)new zzx(string4, zzax2.zzbq));
            return;
        }
        String string5 = zzax.zza(zzax2);
        this.zzap.zza(string, string3, new zzo(this, string4, string5, string, string3)).addOnCompleteListener(this.zzal, (OnCompleteListener)new zzp(this, string, string3, taskCompletionSource, string4));
    }

    final /* synthetic */ void zza(String string, String string2, TaskCompletionSource taskCompletionSource, String string3, Task task) {
        if (task.isSuccessful()) {
            String string4 = (String)task.getResult();
            zzaj.zza("", string, string2, string4, this.zzan.zzad());
            taskCompletionSource.setResult((Object)new zzx(string3, string4));
            return;
        }
        taskCompletionSource.setException(task.getException());
    }

    final /* synthetic */ Task zza(String string, String string2, String string3, String string4) {
        return this.zzao.getToken(string, string2, string3, string4);
    }

    private final class zza {
        private final boolean zzaz;
        private final Subscriber zzba;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> zzbb;
        @GuardedBy(value="this")
        @Nullable
        private Boolean zzbc;

        zza(Subscriber subscriber) {
            this.zzba = subscriber;
            this.zzaz = this.zzu();
            this.zzbc = this.zzt();
            if (this.zzbc == null && this.zzaz) {
                this.zzbb = new zzq(this);
                subscriber.subscribe(DataCollectionDefaultChange.class, this.zzbb);
            }
        }

        final synchronized boolean isEnabled() {
            if (this.zzbc != null) {
                return this.zzbc;
            }
            return this.zzaz && FirebaseInstanceId.this.zzam.isDataCollectionDefaultEnabled();
        }

        final synchronized void setEnabled(boolean bl) {
            if (this.zzbb != null) {
                this.zzba.unsubscribe(DataCollectionDefaultChange.class, this.zzbb);
                this.zzbb = null;
            }
            SharedPreferences.Editor editor = FirebaseInstanceId.this.zzam.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseInstanceId.this.zzg();
            }
            this.zzbc = bl;
        }

        @Nullable
        private final Boolean zzt() {
            Context context = FirebaseInstanceId.this.zzam.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        private final boolean zzu() {
            try {
                Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Context context = FirebaseInstanceId.this.zzam.getApplicationContext();
                Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
                intent.setPackage(context.getPackageName());
                ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
                return resolveInfo != null && resolveInfo.serviceInfo != null;
            }
        }
    }
}

