/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.firebase.FirebaseApp;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

@Hide
public final class zzw {
    private final Context zzaiq;
    private String zzold;
    private String zzcs;
    private int zzole;
    private int zzolf = 0;

    public zzw(Context context) {
        this.zzaiq = context;
    }

    public final synchronized int zzcll() {
        List list;
        Intent intent;
        if (this.zzolf != 0) {
            return this.zzolf;
        }
        PackageManager packageManager = this.zzaiq.getPackageManager();
        if (packageManager.checkPermission("com.google.android.c2dm.permission.SEND", "com.google.android.gms") == -1) {
            Log.e((String)"FirebaseInstanceId", (String)"Google Play services missing or without correct permission.");
            return 0;
        }
        if (!zzs.isAtLeastO()) {
            intent = new Intent("com.google.android.c2dm.intent.REGISTER");
            intent.setPackage("com.google.android.gms");
            list = packageManager.queryIntentServices(intent, 0);
            if (list != null && list.size() > 0) {
                this.zzolf = 1;
                return this.zzolf;
            }
        }
        intent = new Intent("com.google.iid.TOKEN_REQUEST");
        intent.setPackage("com.google.android.gms");
        list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0) {
            this.zzolf = 2;
            return this.zzolf;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Failed to resolve IID implementation package, falling back");
        this.zzolf = zzs.isAtLeastO() ? 2 : 1;
        return this.zzolf;
    }

    public static String zzf(FirebaseApp firebaseApp) {
        String string = firebaseApp.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        String string2 = firebaseApp.getOptions().getApplicationId();
        if (!string2.startsWith("1:")) {
            return string2;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        String string3 = stringArray[1];
        if (string3.isEmpty()) {
            return null;
        }
        return string3;
    }

    public static String zzb(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    public final synchronized String zzclm() {
        if (this.zzold == null) {
            this.zzclp();
        }
        return this.zzold;
    }

    public final synchronized String zzcln() {
        if (this.zzcs == null) {
            this.zzclp();
        }
        return this.zzcs;
    }

    public final synchronized int zzclo() {
        PackageInfo packageInfo;
        if (this.zzole == 0 && (packageInfo = this.zzog("com.google.android.gms")) != null) {
            this.zzole = packageInfo.versionCode;
        }
        return this.zzole;
    }

    private final synchronized void zzclp() {
        PackageInfo packageInfo = this.zzog(this.zzaiq.getPackageName());
        if (packageInfo != null) {
            this.zzold = Integer.toString(packageInfo.versionCode);
            this.zzcs = packageInfo.versionName;
        }
    }

    private final PackageInfo zzog(String string) {
        try {
            return this.zzaiq.getPackageManager().getPackageInfo(string, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return null;
        }
    }
}

