/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzw;
import com.google.firebase.iid.zzx;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FirebaseInstanceId {
    private static final long zzokn = TimeUnit.HOURS.toSeconds(8L);
    private static Map<String, FirebaseInstanceId> zzimu = new ArrayMap();
    private static zzaa zzoko;
    private static ScheduledThreadPoolExecutor zzokp;
    private final FirebaseApp zzmwq;
    private final zzw zzokq;
    private final zzx zzokr;
    private KeyPair zzimx;
    private boolean zzoks = false;
    private boolean zzokt;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzimu.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            if (zzoko == null) {
                zzoko = new zzaa(firebaseApp.getApplicationContext());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp, new zzw(firebaseApp.getApplicationContext()));
            zzimu.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    private FirebaseInstanceId(FirebaseApp firebaseApp, zzw zzw2) {
        if (zzw.zzf(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        this.zzmwq = firebaseApp;
        this.zzokq = zzw2;
        this.zzokr = new zzx(firebaseApp.getApplicationContext(), zzw2);
        this.zzokt = this.zzcli();
        if (this.zzclk()) {
            this.zzclb();
        }
    }

    private final void zzclb() {
        zzab zzab2 = this.zzclc();
        if (zzab2 == null || zzab2.zzru(this.zzokq.zzclm()) || zzoko.zzcls() != null) {
            this.startSync();
        }
    }

    final FirebaseApp getApp() {
        return this.zzmwq;
    }

    final synchronized void zzcy(boolean bl) {
        this.zzoks = bl;
    }

    private final synchronized void startSync() {
        if (!this.zzoks) {
            this.zzcd(0L);
        }
    }

    final synchronized void zzcd(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zzokn);
        FirebaseInstanceId.zzb(new zzac(this, this.zzokq, l2), l);
        this.zzoks = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzb(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzokp == null) {
                zzokp = new ScheduledThreadPoolExecutor(1);
            }
            zzokp.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzclb();
        return zzw.zzb(this.zzawp());
    }

    public long getCreationTime() {
        return zzoko.zzrp("");
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        Bundle bundle = new Bundle();
        bundle.putString("iid-operation", "delete");
        bundle.putString("delete", "1");
        this.zzb("*", "*", bundle);
        this.zzclg();
    }

    @Nullable
    public String getToken() {
        zzab zzab2 = this.zzclc();
        if (zzab2 == null || zzab2.zzru(this.zzokq.zzclm())) {
            this.startSync();
        }
        if (zzab2 != null) {
            return zzab2.zzlnm;
        }
        return null;
    }

    @Nullable
    final zzab zzclc() {
        return zzoko.zzq("", zzw.zzf(this.zzmwq), "*");
    }

    @Hide
    final String zzcld() throws IOException {
        return this.getToken(zzw.zzf(this.zzmwq), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        zzab zzab2 = zzoko.zzq("", string, string2);
        if (zzab2 != null && !zzab2.zzru(this.zzokq.zzclm())) {
            return zzab2.zzlnm;
        }
        String string3 = this.zzb(string, string2, new Bundle());
        if (string3 != null) {
            zzoko.zza("", string, string2, string3, this.zzokq.zzclm());
        }
        return string3;
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        this.zzb(string, string2, bundle);
        zzoko.zzg("", string, string2);
    }

    @Hide
    public final synchronized void zzrl(String string) {
        zzoko.zzrl(string);
        this.startSync();
    }

    static zzaa zzcle() {
        return zzoko;
    }

    final void zzrm(String string) throws IOException {
        zzab zzab2 = this.zzclc();
        if (zzab2 == null || zzab2.zzru(this.zzokq.zzclm())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzb(zzab2.zzlnm, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    final void zzrn(String string) throws IOException {
        zzab zzab2 = this.zzclc();
        if (zzab2 == null || zzab2.zzru(this.zzokq.zzclm())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        bundle.putString("delete", "1");
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzb(zzab2.zzlnm, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    private final String zzb(String string, String string2, Bundle bundle) throws IOException {
        bundle.putString("scope", string2);
        bundle.putString("sender", string);
        bundle.putString("subtype", string);
        bundle.putString("appid", this.getId());
        bundle.putString("gmp_app_id", this.zzmwq.getOptions().getApplicationId());
        bundle.putString("gmsv", Integer.toString(this.zzokq.zzclo()));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", this.zzokq.zzclm());
        bundle.putString("app_ver_name", this.zzokq.zzcln());
        bundle.putString("cliv", "fiid-12211000");
        Bundle bundle2 = this.zzokr.zzah(bundle);
        if (bundle2 == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string3 = bundle2.getString("registration_id");
        if (string3 != null) {
            return string3;
        }
        String string4 = bundle2.getString("unregistered");
        if (string4 != null) {
            return string4;
        }
        String string5 = bundle2.getString("error");
        if ("RST".equals(string5)) {
            this.zzclg();
            throw new IOException("INSTANCE_ID_RESET");
        }
        if (string5 != null) {
            throw new IOException(string5);
        }
        String string6 = String.valueOf(bundle2);
        Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string6).length()).append("Unexpected response: ").append(string6).toString(), (Throwable)new Throwable());
        throw new IOException("SERVICE_NOT_AVAILABLE");
    }

    static boolean zzclf() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    private final synchronized KeyPair zzawp() {
        if (this.zzimx == null) {
            this.zzimx = zzoko.zzrs("");
        }
        if (this.zzimx == null) {
            this.zzimx = zzoko.zzrq("");
        }
        return this.zzimx;
    }

    final synchronized void zzclg() {
        zzoko.zzawz();
        this.zzimx = null;
        if (this.zzclk()) {
            this.startSync();
        }
    }

    final void zzclh() {
        zzoko.zzrr("");
        this.startSync();
    }

    private final boolean zzcli() {
        Context context = this.zzmwq.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("auto_init")) {
            return sharedPreferences.getBoolean("auto_init", true);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return this.zzclj();
    }

    private final boolean zzclj() {
        try {
            Class.forName("com.google.firebase.messaging.FirebaseMessaging");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Context context = this.zzmwq.getApplicationContext();
            Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
            intent.setPackage(context.getPackageName());
            ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
            return resolveInfo != null && resolveInfo.serviceInfo != null;
        }
    }

    @Hide
    public final synchronized boolean zzclk() {
        return this.zzokt;
    }

    @Hide
    public final synchronized void zzcz(boolean bl) {
        SharedPreferences.Editor editor = this.zzmwq.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
        editor.putBoolean("auto_init", bl);
        editor.apply();
        if (!this.zzokt && bl) {
            this.zzclb();
        }
        this.zzokt = bl;
    }
}

