/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.support.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.functions.ContextProvider;
import com.google.firebase.functions.FirebaseContextProvider$$Lambda$1;
import com.google.firebase.functions.HttpsCallableContext;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import com.google.firebase.inject.Provider;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;

class FirebaseContextProvider
implements ContextProvider {
    @Nullable
    private final Provider<InternalAuthProvider> tokenProvider;
    private final Provider<FirebaseInstanceIdInternal> instanceId;

    FirebaseContextProvider(@Nullable Provider<InternalAuthProvider> tokenProvider, Provider<FirebaseInstanceIdInternal> instanceId) {
        this.tokenProvider = tokenProvider;
        this.instanceId = instanceId;
    }

    @Override
    public Task<HttpsCallableContext> getContext() {
        if (this.tokenProvider == null) {
            TaskCompletionSource tcs = new TaskCompletionSource();
            tcs.setResult((Object)new HttpsCallableContext(null, ((FirebaseInstanceIdInternal)this.instanceId.get()).getToken()));
            return tcs.getTask();
        }
        return ((InternalAuthProvider)this.tokenProvider.get()).getAccessToken(false).continueWith(FirebaseContextProvider$$Lambda$1.lambdaFactory$(this));
    }

    static /* synthetic */ HttpsCallableContext lambda$getContext$0(FirebaseContextProvider this_, Task task) throws Exception {
        String authToken = null;
        if (!task.isSuccessful()) {
            Exception exception = task.getException();
            if (!(exception instanceof FirebaseNoSignedInUserException)) {
                throw exception;
            }
        } else {
            authToken = ((GetTokenResult)task.getResult()).getToken();
        }
        String instanceIdToken = ((FirebaseInstanceIdInternal)this_.instanceId.get()).getToken();
        return new HttpsCallableContext(authToken, instanceIdToken);
    }
}

