/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import com.google.firebase.firestore.core.ComponentProvider;
import com.google.firebase.firestore.remote.AndroidConnectivityMonitor;
import com.google.firebase.firestore.remote.ConnectivityMonitor;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.FirestoreCallCredentials;
import com.google.firebase.firestore.remote.FirestoreChannel;
import com.google.firebase.firestore.remote.GrpcCallProvider;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firebase.firestore.util.Assert;

public class RemoteComponenetProvider {
    private GrpcCallProvider grpcCallProvider;
    private RemoteSerializer remoteSerializer;
    private FirestoreChannel firestoreChannel;
    private Datastore datastore;
    private ConnectivityMonitor connectivityMonitor;

    public void initialize(ComponentProvider.Configuration configuration) {
        this.remoteSerializer = this.createRemoteSerializer(configuration);
        this.grpcCallProvider = this.createGrpcCallProvider(configuration);
        this.firestoreChannel = this.createFirestoreChannel(configuration);
        this.datastore = this.createDatastore(configuration);
        this.connectivityMonitor = this.createConnectivityMonitor(configuration);
    }

    public GrpcCallProvider getGrpcCallProvider() {
        return Assert.hardAssertNonNull(this.grpcCallProvider, "grpcCallProvider not initialized yet", new Object[0]);
    }

    public RemoteSerializer getRemoteSerializer() {
        return Assert.hardAssertNonNull(this.remoteSerializer, "remoteSerializer not initialized yet", new Object[0]);
    }

    public FirestoreChannel getFirestoreChannel() {
        return Assert.hardAssertNonNull(this.firestoreChannel, "firestoreChannel not initialized yet", new Object[0]);
    }

    public Datastore getDatastore() {
        return Assert.hardAssertNonNull(this.datastore, "datastore not initialized yet", new Object[0]);
    }

    public ConnectivityMonitor getConnectivityMonitor() {
        return Assert.hardAssertNonNull(this.connectivityMonitor, "connectivityMonitor not initialized yet", new Object[0]);
    }

    protected GrpcCallProvider createGrpcCallProvider(ComponentProvider.Configuration configuration) {
        FirestoreCallCredentials firestoreHeaders = new FirestoreCallCredentials(configuration.authProvider, configuration.appCheckProvider);
        return new GrpcCallProvider(configuration.asyncQueue, configuration.context, configuration.databaseInfo, firestoreHeaders);
    }

    protected RemoteSerializer createRemoteSerializer(ComponentProvider.Configuration configuration) {
        return new RemoteSerializer(configuration.databaseInfo.getDatabaseId());
    }

    protected FirestoreChannel createFirestoreChannel(ComponentProvider.Configuration configuration) {
        return new FirestoreChannel(configuration.asyncQueue, configuration.authProvider, configuration.appCheckProvider, configuration.databaseInfo.getDatabaseId(), configuration.metadataProvider, this.getGrpcCallProvider());
    }

    protected Datastore createDatastore(ComponentProvider.Configuration configuration) {
        return new Datastore(configuration.asyncQueue, this.getRemoteSerializer(), this.getFirestoreChannel());
    }

    protected ConnectivityMonitor createConnectivityMonitor(ComponentProvider.Configuration configuration) {
        return new AndroidConnectivityMonitor(configuration.context);
    }
}

