/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firestore.v1.Value;

public final class MutableDocument
implements Document {
    private final DocumentKey key;
    private DocumentType documentType;
    private SnapshotVersion version;
    private SnapshotVersion readTime;
    private ObjectValue value;
    private DocumentState documentState;

    private MutableDocument(DocumentKey key) {
        this.key = key;
        this.readTime = SnapshotVersion.NONE;
    }

    private MutableDocument(DocumentKey key, DocumentType documentType, SnapshotVersion version, SnapshotVersion readTime, ObjectValue value, DocumentState documentState) {
        this.key = key;
        this.version = version;
        this.readTime = readTime;
        this.documentType = documentType;
        this.documentState = documentState;
        this.value = value;
    }

    public static MutableDocument newInvalidDocument(DocumentKey documentKey) {
        return new MutableDocument(documentKey, DocumentType.INVALID, SnapshotVersion.NONE, SnapshotVersion.NONE, new ObjectValue(), DocumentState.SYNCED);
    }

    public static MutableDocument newFoundDocument(DocumentKey documentKey, SnapshotVersion version, ObjectValue value) {
        return new MutableDocument(documentKey).convertToFoundDocument(version, value);
    }

    public static MutableDocument newNoDocument(DocumentKey documentKey, SnapshotVersion version) {
        return new MutableDocument(documentKey).convertToNoDocument(version);
    }

    public static MutableDocument newUnknownDocument(DocumentKey documentKey, SnapshotVersion version) {
        return new MutableDocument(documentKey).convertToUnknownDocument(version);
    }

    public MutableDocument convertToFoundDocument(SnapshotVersion version, ObjectValue value) {
        this.version = version;
        this.documentType = DocumentType.FOUND_DOCUMENT;
        this.value = value;
        this.documentState = DocumentState.SYNCED;
        return this;
    }

    public MutableDocument convertToNoDocument(SnapshotVersion version) {
        this.version = version;
        this.documentType = DocumentType.NO_DOCUMENT;
        this.value = new ObjectValue();
        this.documentState = DocumentState.SYNCED;
        return this;
    }

    public MutableDocument convertToUnknownDocument(SnapshotVersion version) {
        this.version = version;
        this.documentType = DocumentType.UNKNOWN_DOCUMENT;
        this.value = new ObjectValue();
        this.documentState = DocumentState.HAS_COMMITTED_MUTATIONS;
        return this;
    }

    public MutableDocument setHasCommittedMutations() {
        this.documentState = DocumentState.HAS_COMMITTED_MUTATIONS;
        return this;
    }

    public MutableDocument setHasLocalMutations() {
        this.documentState = DocumentState.HAS_LOCAL_MUTATIONS;
        this.version = SnapshotVersion.NONE;
        return this;
    }

    public MutableDocument setReadTime(SnapshotVersion readTime) {
        this.readTime = readTime;
        return this;
    }

    @Override
    public DocumentKey getKey() {
        return this.key;
    }

    @Override
    public SnapshotVersion getVersion() {
        return this.version;
    }

    @Override
    public SnapshotVersion getReadTime() {
        return this.readTime;
    }

    @Override
    public boolean hasLocalMutations() {
        return this.documentState.equals((Object)DocumentState.HAS_LOCAL_MUTATIONS);
    }

    @Override
    public boolean hasCommittedMutations() {
        return this.documentState.equals((Object)DocumentState.HAS_COMMITTED_MUTATIONS);
    }

    @Override
    public boolean hasPendingWrites() {
        return this.hasLocalMutations() || this.hasCommittedMutations();
    }

    @Override
    public ObjectValue getData() {
        return this.value;
    }

    @Override
    public Value getField(FieldPath field) {
        return this.getData().get(field);
    }

    @Override
    public boolean isValidDocument() {
        return !this.documentType.equals((Object)DocumentType.INVALID);
    }

    @Override
    public boolean isFoundDocument() {
        return this.documentType.equals((Object)DocumentType.FOUND_DOCUMENT);
    }

    @Override
    public boolean isNoDocument() {
        return this.documentType.equals((Object)DocumentType.NO_DOCUMENT);
    }

    @Override
    public boolean isUnknownDocument() {
        return this.documentType.equals((Object)DocumentType.UNKNOWN_DOCUMENT);
    }

    @Override
    @NonNull
    public MutableDocument mutableCopy() {
        return new MutableDocument(this.key, this.documentType, this.version, this.readTime, this.value.clone(), this.documentState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableDocument document = (MutableDocument)o;
        if (!this.key.equals(document.key)) {
            return false;
        }
        if (!this.version.equals(document.version)) {
            return false;
        }
        if (!this.documentType.equals((Object)document.documentType)) {
            return false;
        }
        if (!this.documentState.equals((Object)document.documentState)) {
            return false;
        }
        return this.value.equals(document.value);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "Document{key=" + this.key + ", version=" + this.version + ", readTime=" + this.readTime + ", type=" + (Object)((Object)this.documentType) + ", documentState=" + (Object)((Object)this.documentState) + ", value=" + this.value + '}';
    }

    private static enum DocumentType {
        INVALID,
        FOUND_DOCUMENT,
        NO_DOCUMENT,
        UNKNOWN_DOCUMENT;

    }

    private static enum DocumentState {
        HAS_LOCAL_MUTATIONS,
        HAS_COMMITTED_MUTATIONS,
        SYNCED;

    }
}

