/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.QueryContext;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Assert;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class MemoryRemoteDocumentCache
implements RemoteDocumentCache {
    private ImmutableSortedMap<DocumentKey, Document> docs = DocumentCollections.emptyDocumentMap();
    private IndexManager indexManager;

    MemoryRemoteDocumentCache() {
    }

    @Override
    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    @Override
    public void add(MutableDocument document, SnapshotVersion readTime) {
        Assert.hardAssert(this.indexManager != null, "setIndexManager() not called", new Object[0]);
        Assert.hardAssert(!readTime.equals(SnapshotVersion.NONE), "Cannot add document to the RemoteDocumentCache with a read time of zero", new Object[0]);
        this.docs = this.docs.insert((Object)document.getKey(), (Object)document.mutableCopy().setReadTime(readTime));
        this.indexManager.addToCollectionParentIndex(document.getKey().getCollectionPath());
    }

    @Override
    public void removeAll(Collection<DocumentKey> keys) {
        Assert.hardAssert(this.indexManager != null, "setIndexManager() not called", new Object[0]);
        ImmutableSortedMap deletedDocs = DocumentCollections.emptyDocumentMap();
        for (DocumentKey key : keys) {
            this.docs = this.docs.remove((Object)key);
            deletedDocs = deletedDocs.insert((Object)key, (Object)MutableDocument.newNoDocument(key, SnapshotVersion.NONE));
        }
        this.indexManager.updateIndexEntries(deletedDocs);
    }

    @Override
    public MutableDocument get(DocumentKey key) {
        Document doc = (Document)this.docs.get((Object)key);
        return doc != null ? doc.mutableCopy() : MutableDocument.newInvalidDocument(key);
    }

    @Override
    public Map<DocumentKey, MutableDocument> getAll(Iterable<DocumentKey> keys) {
        HashMap<DocumentKey, MutableDocument> result = new HashMap<DocumentKey, MutableDocument>();
        for (DocumentKey key : keys) {
            result.put(key, this.get(key));
        }
        return result;
    }

    @Override
    public Map<DocumentKey, MutableDocument> getAll(String collectionGroup, FieldIndex.IndexOffset offset, int limit) {
        throw new UnsupportedOperationException("getAll(String, IndexOffset, int) is not supported.");
    }

    @Override
    public Map<DocumentKey, MutableDocument> getDocumentsMatchingQuery(Query query, FieldIndex.IndexOffset offset, @NonNull Set<DocumentKey> mutatedKeys, @Nullable QueryContext context) {
        HashMap<DocumentKey, MutableDocument> result = new HashMap<DocumentKey, MutableDocument>();
        DocumentKey prefix = DocumentKey.fromPath((ResourcePath)((Object)query.getPath().append("")));
        Iterator iterator = this.docs.iteratorFrom((Object)prefix);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Document doc = (Document)entry.getValue();
            DocumentKey key = (DocumentKey)entry.getKey();
            if (!query.getPath().isPrefixOf(key.getPath())) break;
            if (key.getPath().length() > query.getPath().length() + 1 || FieldIndex.IndexOffset.fromDocument(doc).compareTo(offset) <= 0 || !mutatedKeys.contains(doc.getKey()) && !query.matches(doc)) continue;
            result.put(doc.getKey(), doc.mutableCopy());
        }
        return result;
    }

    @Override
    public Map<DocumentKey, MutableDocument> getDocumentsMatchingQuery(Query query, FieldIndex.IndexOffset offset, @NonNull Set<DocumentKey> mutatedKeys) {
        return this.getDocumentsMatchingQuery(query, offset, mutatedKeys, null);
    }

    Iterable<Document> getDocuments() {
        return new DocumentIterable();
    }

    long getByteSize(LocalSerializer serializer) {
        long count = 0L;
        for (Document doc : new DocumentIterable()) {
            count += (long)serializer.encodeMaybeDocument(doc).getSerializedSize();
        }
        return count;
    }

    private class DocumentIterable
    implements Iterable<Document> {
        private DocumentIterable() {
        }

        @Override
        @NonNull
        public Iterator<Document> iterator() {
            final Iterator iterator = MemoryRemoteDocumentCache.this.docs.iterator();
            return new Iterator<Document>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Document next() {
                    return (Document)((Map.Entry)iterator.next()).getValue();
                }
            };
        }
    }
}

