/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.core.ComponentProvider;
import com.google.firebase.firestore.core.MemoryComponentProvider;
import com.google.firebase.firestore.local.IndexBackfiller;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.SQLiteLruReferenceDelegate;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.local.Scheduler;

public class SQLiteComponentProvider
extends MemoryComponentProvider {
    public SQLiteComponentProvider(FirebaseFirestoreSettings settings) {
        super(settings);
    }

    @Override
    protected Scheduler createGarbageCollectionScheduler(ComponentProvider.Configuration configuration) {
        SQLiteLruReferenceDelegate lruDelegate = ((SQLitePersistence)this.getPersistence()).getReferenceDelegate();
        LruGarbageCollector gc = lruDelegate.getGarbageCollector();
        return gc.newScheduler(configuration.asyncQueue, this.getLocalStore());
    }

    @Override
    protected IndexBackfiller createIndexBackfiller(ComponentProvider.Configuration configuration) {
        return new IndexBackfiller(this.getPersistence(), configuration.asyncQueue, this.getLocalStore());
    }

    @Override
    protected Persistence createPersistence(ComponentProvider.Configuration configuration) {
        LocalSerializer serializer = new LocalSerializer(this.getRemoteSerializer());
        LruGarbageCollector.Params params = LruGarbageCollector.Params.WithCacheSizeBytes(this.settings.getCacheSizeBytes());
        return new SQLitePersistence(configuration.context, configuration.databaseInfo.getPersistenceKey(), configuration.databaseInfo.getDatabaseId(), serializer, params);
    }
}

