/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.core.EventManager;
import com.google.firebase.firestore.core.MemoryComponentProvider;
import com.google.firebase.firestore.core.SQLiteComponentProvider;
import com.google.firebase.firestore.core.SyncEngine;
import com.google.firebase.firestore.local.IndexBackfiller;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.Scheduler;
import com.google.firebase.firestore.remote.ConnectivityMonitor;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.GrpcMetadataProvider;
import com.google.firebase.firestore.remote.RemoteComponenetProvider;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firebase.firestore.remote.RemoteStore;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;

public abstract class ComponentProvider {
    protected final FirebaseFirestoreSettings settings;
    private RemoteComponenetProvider remoteProvider = new RemoteComponenetProvider();
    private Persistence persistence;
    private LocalStore localStore;
    private SyncEngine syncEngine;
    private RemoteStore remoteStore;
    private EventManager eventManager;
    @Nullable
    private IndexBackfiller indexBackfiller;
    @Nullable
    private Scheduler garbageCollectionScheduler;

    public ComponentProvider(FirebaseFirestoreSettings settings) {
        this.settings = settings;
    }

    @NonNull
    public static ComponentProvider defaultFactory(@NonNull FirebaseFirestoreSettings settings) {
        return settings.isPersistenceEnabled() ? new SQLiteComponentProvider(settings) : new MemoryComponentProvider(settings);
    }

    @VisibleForTesting
    public void setRemoteProvider(RemoteComponenetProvider remoteProvider) {
        Assert.hardAssert(this.remoteStore == null, "cannot set remoteProvider after initialize", new Object[0]);
        this.remoteProvider = remoteProvider;
    }

    public RemoteSerializer getRemoteSerializer() {
        return this.remoteProvider.getRemoteSerializer();
    }

    public Datastore getDatastore() {
        return this.remoteProvider.getDatastore();
    }

    public Persistence getPersistence() {
        return Assert.hardAssertNonNull(this.persistence, "persistence not initialized yet", new Object[0]);
    }

    @Nullable
    public Scheduler getGarbageCollectionScheduler() {
        return this.garbageCollectionScheduler;
    }

    @Nullable
    public IndexBackfiller getIndexBackfiller() {
        return this.indexBackfiller;
    }

    public LocalStore getLocalStore() {
        return Assert.hardAssertNonNull(this.localStore, "localStore not initialized yet", new Object[0]);
    }

    public SyncEngine getSyncEngine() {
        return Assert.hardAssertNonNull(this.syncEngine, "syncEngine not initialized yet", new Object[0]);
    }

    public RemoteStore getRemoteStore() {
        return Assert.hardAssertNonNull(this.remoteStore, "remoteStore not initialized yet", new Object[0]);
    }

    public EventManager getEventManager() {
        return Assert.hardAssertNonNull(this.eventManager, "eventManager not initialized yet", new Object[0]);
    }

    protected ConnectivityMonitor getConnectivityMonitor() {
        return this.remoteProvider.getConnectivityMonitor();
    }

    public void initialize(Configuration configuration) {
        this.remoteProvider.initialize(configuration);
        this.persistence = this.createPersistence(configuration);
        this.persistence.start();
        this.localStore = this.createLocalStore(configuration);
        this.remoteStore = this.createRemoteStore(configuration);
        this.syncEngine = this.createSyncEngine(configuration);
        this.eventManager = this.createEventManager(configuration);
        this.localStore.start();
        this.remoteStore.start();
        this.garbageCollectionScheduler = this.createGarbageCollectionScheduler(configuration);
        this.indexBackfiller = this.createIndexBackfiller(configuration);
    }

    protected abstract Scheduler createGarbageCollectionScheduler(Configuration var1);

    protected abstract IndexBackfiller createIndexBackfiller(Configuration var1);

    protected abstract EventManager createEventManager(Configuration var1);

    protected abstract LocalStore createLocalStore(Configuration var1);

    protected abstract Persistence createPersistence(Configuration var1);

    protected abstract RemoteStore createRemoteStore(Configuration var1);

    protected abstract SyncEngine createSyncEngine(Configuration var1);

    public static final class Configuration {
        public final Context context;
        public final AsyncQueue asyncQueue;
        public final DatabaseInfo databaseInfo;
        public final User initialUser;
        public final int maxConcurrentLimboResolutions;
        public final CredentialsProvider<User> authProvider;
        public final CredentialsProvider<String> appCheckProvider;
        @Nullable
        public final GrpcMetadataProvider metadataProvider;

        public Configuration(Context context, AsyncQueue asyncQueue, DatabaseInfo databaseInfo, User initialUser, int maxConcurrentLimboResolutions, CredentialsProvider<User> authProvider, CredentialsProvider<String> appCheckProvider, @Nullable GrpcMetadataProvider metadataProvider) {
            this.context = context;
            this.asyncQueue = asyncQueue;
            this.databaseInfo = databaseInfo;
            this.initialUser = initialUser;
            this.maxConcurrentLimboResolutions = maxConcurrentLimboResolutions;
            this.authProvider = authProvider;
            this.appCheckProvider = appCheckProvider;
            this.metadataProvider = metadataProvider;
        }
    }
}

