/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.VectorValue;
import com.google.firebase.firestore.core.UserData;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.model.mutation.ArrayTransformOperation;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.NumericIncrementTransformOperation;
import com.google.firebase.firestore.model.mutation.ServerTimestampOperation;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.CustomClassMapper;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firebase.firestore.util.Util;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import com.google.protobuf.NullValue;
import com.google.type.LatLng;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class UserDataReader {
    private final DatabaseId databaseId;

    public UserDataReader(DatabaseId databaseId) {
        this.databaseId = databaseId;
    }

    public UserData.ParsedSetData parseSetData(Object input) {
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.Set);
        ObjectValue updateData = this.convertAndParseDocumentData(input, accumulator.rootContext());
        return accumulator.toSetData(updateData);
    }

    public UserData.ParsedSetData parseMergeData(Object input, @Nullable FieldMask fieldMask) {
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.MergeSet);
        ObjectValue updateData = this.convertAndParseDocumentData(input, accumulator.rootContext());
        if (fieldMask != null) {
            for (com.google.firebase.firestore.model.FieldPath field : fieldMask.getMask()) {
                if (accumulator.contains(field)) continue;
                throw new IllegalArgumentException("Field '" + field.toString() + "' is specified in your field mask but not in your input data.");
            }
            return accumulator.toMergeData(updateData, fieldMask);
        }
        return accumulator.toMergeData(updateData);
    }

    public UserData.ParsedUpdateData parseUpdateData(Map<String, Object> data) {
        Preconditions.checkNotNull(data, "Provided update data must not be null.");
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.Update);
        UserData.ParseContext context = accumulator.rootContext();
        ObjectValue updateData = new ObjectValue();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            com.google.firebase.firestore.model.FieldPath fieldPath = FieldPath.fromDotSeparatedPath(entry.getKey()).getInternalPath();
            Object fieldValue = entry.getValue();
            if (fieldValue instanceof FieldValue.DeleteFieldValue) {
                context.addToFieldMask(fieldPath);
                continue;
            }
            Value parsedValue = this.convertAndParseFieldData(fieldValue, context.childContext(fieldPath));
            if (parsedValue == null) continue;
            context.addToFieldMask(fieldPath);
            updateData.set(fieldPath, parsedValue);
        }
        return accumulator.toUpdateData(updateData);
    }

    public UserData.ParsedUpdateData parseUpdateData(List<Object> fieldsAndValues) {
        Assert.hardAssert(fieldsAndValues.size() % 2 == 0, "Expected fieldAndValues to contain an even number of elements", new Object[0]);
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.Update);
        UserData.ParseContext context = accumulator.rootContext();
        ObjectValue updateData = new ObjectValue();
        Iterator<Object> iterator = fieldsAndValues.iterator();
        while (iterator.hasNext()) {
            Object fieldPath = iterator.next();
            Object fieldValue = iterator.next();
            Assert.hardAssert(fieldPath instanceof String || fieldPath instanceof FieldPath, "Expected argument to be String or FieldPath.", new Object[0]);
            com.google.firebase.firestore.model.FieldPath parsedField = fieldPath instanceof String ? FieldPath.fromDotSeparatedPath((String)fieldPath).getInternalPath() : ((FieldPath)fieldPath).getInternalPath();
            if (fieldValue instanceof FieldValue.DeleteFieldValue) {
                context.addToFieldMask(parsedField);
                continue;
            }
            Value parsedValue = this.convertAndParseFieldData(fieldValue, context.childContext(parsedField));
            if (parsedValue == null) continue;
            context.addToFieldMask(parsedField);
            updateData.set(parsedField, parsedValue);
        }
        return accumulator.toUpdateData(updateData);
    }

    public Value parseQueryValue(Object input) {
        return this.parseQueryValue(input, false);
    }

    public Value parseQueryValue(Object input, boolean allowArrays) {
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(allowArrays ? UserData.Source.ArrayArgument : UserData.Source.Argument);
        Value parsed = this.convertAndParseFieldData(input, accumulator.rootContext());
        Assert.hardAssert(parsed != null, "Parsed data should not be null.", new Object[0]);
        Assert.hardAssert(accumulator.getFieldTransforms().isEmpty(), "Field transforms should have been disallowed.", new Object[0]);
        return parsed;
    }

    public Value convertAndParseFieldData(Object input, UserData.ParseContext context) {
        Object converted = CustomClassMapper.convertToPlainJavaTypes(input);
        return this.parseData(converted, context);
    }

    private ObjectValue convertAndParseDocumentData(Object input, UserData.ParseContext context) {
        String badDocReason = "Invalid data. Data must be a Map<String, Object> or a suitable POJO object, but it was ";
        if (input.getClass().isArray()) {
            throw new IllegalArgumentException(badDocReason + "an array");
        }
        Object converted = CustomClassMapper.convertToPlainJavaTypes(input);
        Value parsedValue = this.parseData(converted, context);
        if (parsedValue.getValueTypeCase() != Value.ValueTypeCase.MAP_VALUE) {
            throw new IllegalArgumentException(badDocReason + "of type: " + Util.typeName(input));
        }
        return new ObjectValue(parsedValue);
    }

    @Nullable
    private Value parseData(Object input, UserData.ParseContext context) {
        if (input instanceof Map) {
            return this.parseMap((Map)input, context);
        }
        if (input instanceof FieldValue) {
            this.parseSentinelFieldValue((FieldValue)input, context);
            return null;
        }
        if (context.getPath() != null) {
            context.addToFieldMask(context.getPath());
        }
        if (input instanceof List) {
            if (context.isArrayElement() && context.getDataSource() != UserData.Source.ArrayArgument) {
                throw context.createError("Nested arrays are not supported");
            }
            return this.parseList((List)input, context);
        }
        return this.parseScalarValue(input, context);
    }

    private <K, V> Value parseMap(Map<K, V> map2, UserData.ParseContext context) {
        if (map2.isEmpty()) {
            if (context.getPath() != null && !context.getPath().isEmpty()) {
                context.addToFieldMask(context.getPath());
            }
            return (Value)Value.newBuilder().setMapValue(MapValue.getDefaultInstance()).build();
        }
        MapValue.Builder mapBuilder = MapValue.newBuilder();
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw context.createError(String.format("Non-String Map key (%s) is not allowed", entry.getValue()));
            }
            String key = (String)entry.getKey();
            Value parsedValue = this.parseData(entry.getValue(), context.childContext(key));
            if (parsedValue == null) continue;
            mapBuilder.putFields(key, parsedValue);
        }
        return (Value)Value.newBuilder().setMapValue(mapBuilder).build();
    }

    private <T> Value parseList(List<T> list, UserData.ParseContext context) {
        ArrayValue.Builder arrayBuilder = ArrayValue.newBuilder();
        int entryIndex = 0;
        for (T entry : list) {
            Value parsedEntry = this.parseData(entry, context.childContext(entryIndex));
            if (parsedEntry == null) {
                parsedEntry = (Value)Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
            }
            arrayBuilder.addValues(parsedEntry);
            ++entryIndex;
        }
        return (Value)Value.newBuilder().setArrayValue(arrayBuilder).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseSentinelFieldValue(FieldValue value, UserData.ParseContext context) {
        if (!context.isWrite()) {
            throw context.createError(String.format("%s() can only be used with set() and update()", value.getMethodName()));
        }
        if (context.getPath() == null) {
            throw context.createError(String.format("%s() is not currently supported inside arrays", value.getMethodName()));
        }
        if (value instanceof FieldValue.DeleteFieldValue) {
            if (context.getDataSource() == UserData.Source.MergeSet) {
                context.addToFieldMask(context.getPath());
                return;
            }
            if (context.getDataSource() != UserData.Source.Update) throw context.createError("FieldValue.delete() can only be used with update() and set() with SetOptions.merge()");
            Assert.hardAssert(context.getPath().length() > 0, "FieldValue.delete() at the top level should have already been handled.", new Object[0]);
            throw context.createError("FieldValue.delete() can only appear at the top level of your update data");
        }
        if (value instanceof FieldValue.ServerTimestampFieldValue) {
            context.addToFieldTransforms(context.getPath(), ServerTimestampOperation.getInstance());
            return;
        }
        if (value instanceof FieldValue.ArrayUnionFieldValue) {
            List<Value> parsedElements = this.parseArrayTransformElements(((FieldValue.ArrayUnionFieldValue)value).getElements());
            ArrayTransformOperation.Union arrayUnion = new ArrayTransformOperation.Union(parsedElements);
            context.addToFieldTransforms(context.getPath(), arrayUnion);
            return;
        }
        if (value instanceof FieldValue.ArrayRemoveFieldValue) {
            List<Value> parsedElements = this.parseArrayTransformElements(((FieldValue.ArrayRemoveFieldValue)value).getElements());
            ArrayTransformOperation.Remove arrayRemove = new ArrayTransformOperation.Remove(parsedElements);
            context.addToFieldTransforms(context.getPath(), arrayRemove);
            return;
        }
        if (value instanceof FieldValue.NumericIncrementFieldValue) {
            FieldValue.NumericIncrementFieldValue numericIncrementFieldValue = (FieldValue.NumericIncrementFieldValue)value;
            Value operand = this.parseQueryValue(numericIncrementFieldValue.getOperand());
            NumericIncrementTransformOperation incrementOperation = new NumericIncrementTransformOperation(operand);
            context.addToFieldTransforms(context.getPath(), incrementOperation);
            return;
        }
        throw Assert.fail("Unknown FieldValue type: %s", Util.typeName(value));
    }

    private Value parseScalarValue(Object input, UserData.ParseContext context) {
        if (input == null) {
            return (Value)Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        }
        if (input instanceof Integer) {
            return (Value)Value.newBuilder().setIntegerValue(((Integer)input).intValue()).build();
        }
        if (input instanceof Long) {
            return (Value)Value.newBuilder().setIntegerValue((Long)input).build();
        }
        if (input instanceof Float) {
            return (Value)Value.newBuilder().setDoubleValue(((Float)input).doubleValue()).build();
        }
        if (input instanceof Double) {
            return (Value)Value.newBuilder().setDoubleValue((Double)input).build();
        }
        if (input instanceof Boolean) {
            return (Value)Value.newBuilder().setBooleanValue((Boolean)input).build();
        }
        if (input instanceof String) {
            return (Value)Value.newBuilder().setStringValue((String)input).build();
        }
        if (input instanceof Date) {
            Timestamp timestamp = new Timestamp((Date)input);
            return this.parseTimestamp(timestamp);
        }
        if (input instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)input;
            return this.parseTimestamp(timestamp);
        }
        if (input instanceof GeoPoint) {
            GeoPoint geoPoint = (GeoPoint)input;
            return (Value)Value.newBuilder().setGeoPointValue(LatLng.newBuilder().setLatitude(geoPoint.getLatitude()).setLongitude(geoPoint.getLongitude())).build();
        }
        if (input instanceof Blob) {
            return (Value)Value.newBuilder().setBytesValue(((Blob)input).toByteString()).build();
        }
        if (input instanceof DocumentReference) {
            DatabaseId otherDb;
            DocumentReference ref = (DocumentReference)input;
            if (ref.getFirestore() != null && !(otherDb = ref.getFirestore().getDatabaseId()).equals(this.databaseId)) {
                throw context.createError(String.format("Document reference is for database %s/%s but should be for database %s/%s", otherDb.getProjectId(), otherDb.getDatabaseId(), this.databaseId.getProjectId(), this.databaseId.getDatabaseId()));
            }
            return (Value)Value.newBuilder().setReferenceValue(String.format("projects/%s/databases/%s/documents/%s", this.databaseId.getProjectId(), this.databaseId.getDatabaseId(), ((DocumentReference)input).getPath())).build();
        }
        if (input instanceof VectorValue) {
            return this.parseVectorValue((VectorValue)input, context);
        }
        if (input.getClass().isArray()) {
            throw context.createError("Arrays are not supported; use a List instead");
        }
        throw context.createError("Unsupported type: " + Util.typeName(input));
    }

    private Value parseVectorValue(VectorValue vector, UserData.ParseContext context) {
        MapValue.Builder mapBuilder = MapValue.newBuilder();
        mapBuilder.putFields("__type__", Values.VECTOR_VALUE_TYPE);
        mapBuilder.putFields("value", this.parseData(vector.toList(), context));
        return (Value)Value.newBuilder().setMapValue(mapBuilder).build();
    }

    private Value parseTimestamp(Timestamp timestamp) {
        int truncatedNanoseconds = timestamp.getNanoseconds() / 1000 * 1000;
        return (Value)Value.newBuilder().setTimestampValue(com.google.protobuf.Timestamp.newBuilder().setSeconds(timestamp.getSeconds()).setNanos(truncatedNanoseconds)).build();
    }

    private List<Value> parseArrayTransformElements(List<Object> elements) {
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.Argument);
        ArrayList<Value> result = new ArrayList<Value>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            Object element = elements.get(i);
            UserData.ParseContext context = accumulator.rootContext();
            result.add(this.convertAndParseFieldData(element, context.childContext(i)));
        }
        return result;
    }
}

