/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import com.google.android.gms.tasks.Task;
import com.google.firebase.firestore.core.FirestoreClient;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Function;
import java.util.concurrent.Executor;

final class FirestoreClientProvider {
    private final Function<AsyncQueue, FirestoreClient> clientFactory;
    @GuardedBy(value="this")
    private FirestoreClient client;
    @GuardedBy(value="this")
    private AsyncQueue asyncQueue;

    FirestoreClientProvider(Function<AsyncQueue, FirestoreClient> clientFactory) {
        this.clientFactory = clientFactory;
        this.asyncQueue = new AsyncQueue();
    }

    boolean isConfigured() {
        return this.client != null;
    }

    synchronized void ensureConfigured() {
        if (!this.isConfigured()) {
            this.client = this.clientFactory.apply(this.asyncQueue);
        }
    }

    synchronized <T> T call(Function<FirestoreClient, T> call) {
        this.ensureConfigured();
        return call.apply(this.client);
    }

    synchronized void procedure(Consumer<FirestoreClient> call) {
        this.ensureConfigured();
        call.accept((Object)this.client);
    }

    synchronized <T> T executeIfShutdown(Function<Executor, T> callIf, Function<Executor, T> callElse) {
        Executor executor = command -> this.asyncQueue.enqueueAndForgetEvenAfterShutdown(command);
        if (this.client == null || this.client.isTerminated()) {
            return callIf.apply(executor);
        }
        return callElse.apply(executor);
    }

    synchronized Task<Void> terminate() {
        this.ensureConfigured();
        Task<Void> terminate = this.client.terminate();
        this.asyncQueue.shutdown();
        return terminate;
    }

    @VisibleForTesting
    AsyncQueue getAsyncQueue() {
        return this.asyncQueue;
    }
}

