/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.PreviewApi;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.emulators.EmulatedServiceSettings;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.FirestoreClientProvider;
import com.google.firebase.firestore.FirestoreMultiDbComponent;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.LoadBundleTask;
import com.google.firebase.firestore.PersistentCacheIndexManager;
import com.google.firebase.firestore.PersistentCacheSettings;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.TransactionOptions;
import com.google.firebase.firestore.UserDataReader;
import com.google.firebase.firestore.WriteBatch;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.FirebaseAppCheckTokenProvider;
import com.google.firebase.firestore.auth.FirebaseAuthCredentialsProvider;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.ActivityScope;
import com.google.firebase.firestore.core.AsyncEventListener;
import com.google.firebase.firestore.core.ComponentProvider;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.core.FirestoreClient;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.remote.FirestoreChannel;
import com.google.firebase.firestore.remote.GrpcMetadataProvider;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.ByteBufferInputStream;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Function;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firebase.inject.Deferred;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseFirestore {
    private final Function<FirebaseFirestoreSettings, ComponentProvider> componentProviderFactory;
    private static final String TAG = "FirebaseFirestore";
    private final Context context;
    private final DatabaseId databaseId;
    private final String persistenceKey;
    private final CredentialsProvider<User> authProvider;
    private final CredentialsProvider<String> appCheckProvider;
    private final FirebaseApp firebaseApp;
    private final UserDataReader userDataReader;
    private final InstanceRegistry instanceRegistry;
    @Nullable
    private EmulatedServiceSettings emulatorSettings;
    private FirebaseFirestoreSettings settings;
    final FirestoreClientProvider clientProvider;
    private final GrpcMetadataProvider metadataProvider;
    @Nullable
    private PersistentCacheIndexManager persistentCacheIndexManager;

    @NonNull
    private static FirebaseApp getDefaultFirebaseApp() {
        FirebaseApp app = FirebaseApp.getInstance();
        if (app == null) {
            throw new IllegalStateException("You must call FirebaseApp.initializeApp first.");
        }
        return app;
    }

    @NonNull
    public static FirebaseFirestore getInstance() {
        return FirebaseFirestore.getInstance(FirebaseFirestore.getDefaultFirebaseApp(), "(default)");
    }

    @NonNull
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp app) {
        return FirebaseFirestore.getInstance(app, "(default)");
    }

    @NonNull
    public static FirebaseFirestore getInstance(@NonNull String database) {
        return FirebaseFirestore.getInstance(FirebaseFirestore.getDefaultFirebaseApp(), database);
    }

    @NonNull
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp app, @NonNull String database) {
        Preconditions.checkNotNull(app, "Provided FirebaseApp must not be null.");
        Preconditions.checkNotNull(database, "Provided database name must not be null.");
        FirestoreMultiDbComponent component = (FirestoreMultiDbComponent)app.get(FirestoreMultiDbComponent.class);
        Preconditions.checkNotNull(component, "Firestore component is not present.");
        return component.get(database);
    }

    @NonNull
    static FirebaseFirestore newInstance(@NonNull Context context, @NonNull FirebaseApp app, @NonNull Deferred<InternalAuthProvider> deferredAuthProvider, @NonNull Deferred<InteropAppCheckTokenProvider> deferredAppCheckTokenProvider, @NonNull String database, @NonNull InstanceRegistry instanceRegistry, @Nullable GrpcMetadataProvider metadataProvider) {
        String projectId = app.getOptions().getProjectId();
        if (projectId == null) {
            throw new IllegalArgumentException("FirebaseOptions.getProjectId() cannot be null");
        }
        DatabaseId databaseId = DatabaseId.forDatabase(projectId, database);
        FirebaseAuthCredentialsProvider authProvider = new FirebaseAuthCredentialsProvider(deferredAuthProvider);
        FirebaseAppCheckTokenProvider appCheckProvider = new FirebaseAppCheckTokenProvider(deferredAppCheckTokenProvider);
        String persistenceKey = app.getName();
        return new FirebaseFirestore(context, databaseId, persistenceKey, authProvider, appCheckProvider, ComponentProvider::defaultFactory, app, instanceRegistry, metadataProvider);
    }

    @VisibleForTesting
    FirebaseFirestore(Context context, DatabaseId databaseId, String persistenceKey, CredentialsProvider<User> authProvider, CredentialsProvider<String> appCheckProvider, @NonNull Function<FirebaseFirestoreSettings, ComponentProvider> componentProviderFactory, @Nullable FirebaseApp firebaseApp, InstanceRegistry instanceRegistry, @Nullable GrpcMetadataProvider metadataProvider) {
        this.context = Preconditions.checkNotNull(context);
        this.databaseId = Preconditions.checkNotNull(Preconditions.checkNotNull(databaseId));
        this.userDataReader = new UserDataReader(databaseId);
        this.persistenceKey = Preconditions.checkNotNull(persistenceKey);
        this.authProvider = Preconditions.checkNotNull(authProvider);
        this.appCheckProvider = Preconditions.checkNotNull(appCheckProvider);
        this.componentProviderFactory = Preconditions.checkNotNull(componentProviderFactory);
        this.clientProvider = new FirestoreClientProvider(this::newClient);
        this.firebaseApp = firebaseApp;
        this.instanceRegistry = instanceRegistry;
        this.metadataProvider = metadataProvider;
        this.settings = new FirebaseFirestoreSettings.Builder().build();
    }

    @NonNull
    public FirebaseFirestoreSettings getFirestoreSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirestoreSettings(@NonNull FirebaseFirestoreSettings settings) {
        Preconditions.checkNotNull(settings, "Provided settings must not be null.");
        DatabaseId databaseId = this.databaseId;
        synchronized (databaseId) {
            settings = this.mergeEmulatorSettings(settings, this.emulatorSettings);
            if (this.clientProvider.isConfigured() && !this.settings.equals(settings)) {
                throw new IllegalStateException("FirebaseFirestore has already been started and its settings can no longer be changed. You can only call setFirestoreSettings() before calling any other methods on a FirebaseFirestore object.");
            }
            this.settings = settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useEmulator(@NonNull String host, int port) {
        FirestoreClientProvider firestoreClientProvider = this.clientProvider;
        synchronized (firestoreClientProvider) {
            if (this.clientProvider.isConfigured()) {
                throw new IllegalStateException("Cannot call useEmulator() after instance has already been initialized.");
            }
            this.emulatorSettings = new EmulatedServiceSettings(host, port);
            this.settings = this.mergeEmulatorSettings(this.settings, this.emulatorSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirestoreClient newClient(AsyncQueue asyncQueue) {
        FirestoreClientProvider firestoreClientProvider = this.clientProvider;
        synchronized (firestoreClientProvider) {
            DatabaseInfo databaseInfo = new DatabaseInfo(this.databaseId, this.persistenceKey, this.settings.getHost(), this.settings.isSslEnabled());
            return new FirestoreClient(this.context, databaseInfo, this.authProvider, this.appCheckProvider, asyncQueue, this.metadataProvider, this.componentProviderFactory.apply(this.settings));
        }
    }

    private FirebaseFirestoreSettings mergeEmulatorSettings(@NonNull FirebaseFirestoreSettings settings, @Nullable EmulatedServiceSettings emulatorSettings) {
        if (emulatorSettings == null) {
            return settings;
        }
        if (!"firestore.googleapis.com".equals(settings.getHost())) {
            Logger.warn(TAG, "Host has been set in FirebaseFirestoreSettings and useEmulator, emulator host will be used.", new Object[0]);
        }
        return new FirebaseFirestoreSettings.Builder(settings).setHost(emulatorSettings.getHost() + ":" + emulatorSettings.getPort()).setSslEnabled(false).build();
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.firebaseApp;
    }

    @Deprecated
    @PreviewApi
    @NonNull
    public Task<Void> setIndexConfiguration(@NonNull String json) {
        this.clientProvider.ensureConfigured();
        Preconditions.checkState(this.settings.isPersistenceEnabled(), "Cannot enable indexes when persistence is disabled");
        ArrayList<FieldIndex> parsedIndexes = new ArrayList<FieldIndex>();
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("indexes")) {
                JSONArray indexes = jsonObject.getJSONArray("indexes");
                for (int i = 0; i < indexes.length(); ++i) {
                    JSONObject definition = indexes.getJSONObject(i);
                    String collectionGroup = definition.getString("collectionGroup");
                    ArrayList<FieldIndex.Segment> segments = new ArrayList<FieldIndex.Segment>();
                    JSONArray fields = definition.optJSONArray("fields");
                    for (int f = 0; fields != null && f < fields.length(); ++f) {
                        JSONObject field = fields.getJSONObject(f);
                        FieldPath fieldPath = FieldPath.fromServerFormat(field.getString("fieldPath"));
                        if ("CONTAINS".equals(field.optString("arrayConfig"))) {
                            segments.add(FieldIndex.Segment.create(fieldPath, FieldIndex.Segment.Kind.CONTAINS));
                            continue;
                        }
                        if ("ASCENDING".equals(field.optString("order"))) {
                            segments.add(FieldIndex.Segment.create(fieldPath, FieldIndex.Segment.Kind.ASCENDING));
                            continue;
                        }
                        segments.add(FieldIndex.Segment.create(fieldPath, FieldIndex.Segment.Kind.DESCENDING));
                    }
                    parsedIndexes.add(FieldIndex.create(-1, collectionGroup, segments, FieldIndex.INITIAL_STATE));
                }
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Failed to parse index configuration", e);
        }
        return (Task)this.clientProvider.call(client -> client.configureFieldIndexes(parsedIndexes));
    }

    @Nullable
    public PersistentCacheIndexManager getPersistentCacheIndexManager() {
        this.clientProvider.ensureConfigured();
        if (this.persistentCacheIndexManager == null && (this.settings.isPersistenceEnabled() || this.settings.getCacheSettings() instanceof PersistentCacheSettings)) {
            this.persistentCacheIndexManager = new PersistentCacheIndexManager(this.clientProvider);
        }
        return this.persistentCacheIndexManager;
    }

    @NonNull
    public CollectionReference collection(@NonNull String collectionPath) {
        Preconditions.checkNotNull(collectionPath, "Provided collection path must not be null.");
        this.clientProvider.ensureConfigured();
        return new CollectionReference(ResourcePath.fromString(collectionPath), this);
    }

    @NonNull
    public DocumentReference document(@NonNull String documentPath) {
        Preconditions.checkNotNull(documentPath, "Provided document path must not be null.");
        this.clientProvider.ensureConfigured();
        return DocumentReference.forPath(ResourcePath.fromString(documentPath), this);
    }

    @NonNull
    public com.google.firebase.firestore.Query collectionGroup(@NonNull String collectionId) {
        Preconditions.checkNotNull(collectionId, "Provided collection ID must not be null.");
        if (collectionId.contains("/")) {
            throw new IllegalArgumentException(String.format("Invalid collectionId '%s'. Collection IDs must not contain '/'.", collectionId));
        }
        this.clientProvider.ensureConfigured();
        return new com.google.firebase.firestore.Query(new Query(ResourcePath.EMPTY, collectionId), this);
    }

    private <ResultT> Task<ResultT> runTransaction(TransactionOptions options, Transaction.Function<ResultT> updateFunction, Executor executor) {
        this.clientProvider.ensureConfigured();
        Function wrappedUpdateFunction = internalTransaction -> Tasks.call((Executor)executor, () -> updateFunction.apply(new com.google.firebase.firestore.Transaction((Transaction)internalTransaction, this)));
        return (Task)this.clientProvider.call(client -> client.transaction(options, wrappedUpdateFunction));
    }

    @NonNull
    public <TResult> Task<TResult> runTransaction(@NonNull Transaction.Function<TResult> updateFunction) {
        return this.runTransaction(TransactionOptions.DEFAULT, updateFunction);
    }

    @NonNull
    public <TResult> Task<TResult> runTransaction(@NonNull TransactionOptions options, @NonNull Transaction.Function<TResult> updateFunction) {
        Preconditions.checkNotNull(updateFunction, "Provided transaction update function must not be null.");
        return this.runTransaction(options, updateFunction, Transaction.getDefaultExecutor());
    }

    @NonNull
    public WriteBatch batch() {
        this.clientProvider.ensureConfigured();
        return new WriteBatch(this);
    }

    @NonNull
    public Task<Void> runBatch(@NonNull WriteBatch.Function batchFunction) {
        WriteBatch batch = this.batch();
        batchFunction.apply(batch);
        return batch.commit();
    }

    @NonNull
    public Task<Void> terminate() {
        this.instanceRegistry.remove(this.getDatabaseId().getDatabaseId());
        return this.clientProvider.terminate();
    }

    @NonNull
    public Task<Void> waitForPendingWrites() {
        return (Task)this.clientProvider.call(FirestoreClient::waitForPendingWrites);
    }

    @NonNull
    public Task<Void> enableNetwork() {
        return (Task)this.clientProvider.call(FirestoreClient::enableNetwork);
    }

    @NonNull
    public Task<Void> disableNetwork() {
        return (Task)this.clientProvider.call(FirestoreClient::disableNetwork);
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        if (loggingEnabled) {
            Logger.setLogLevel(Logger.Level.DEBUG);
        } else {
            Logger.setLogLevel(Logger.Level.WARN);
        }
    }

    @NonNull
    public Task<Void> clearPersistence() {
        return (Task)this.clientProvider.executeIfShutdown(this::clearPersistence, executor -> Tasks.forException((Exception)((Object)new FirebaseFirestoreException("Persistence cannot be cleared while the firestore instance is running.", FirebaseFirestoreException.Code.FAILED_PRECONDITION))));
    }

    @NonNull
    private Task<Void> clearPersistence(Executor executor) {
        TaskCompletionSource source = new TaskCompletionSource();
        executor.execute(() -> {
            try {
                SQLitePersistence.clearPersistence(this.context, this.databaseId, this.persistenceKey);
                source.setResult(null);
            }
            catch (FirebaseFirestoreException e) {
                source.setException((Exception)((Object)e));
            }
        });
        return source.getTask();
    }

    @NonNull
    public ListenerRegistration addSnapshotsInSyncListener(@NonNull Runnable runnable) {
        return this.addSnapshotsInSyncListener(Executors.DEFAULT_CALLBACK_EXECUTOR, runnable);
    }

    @NonNull
    public ListenerRegistration addSnapshotsInSyncListener(@NonNull Activity activity, @NonNull Runnable runnable) {
        return this.addSnapshotsInSyncListener(Executors.DEFAULT_CALLBACK_EXECUTOR, activity, runnable);
    }

    @NonNull
    public ListenerRegistration addSnapshotsInSyncListener(@NonNull Executor executor, @NonNull Runnable runnable) {
        return this.addSnapshotsInSyncListener(executor, null, runnable);
    }

    @NonNull
    public LoadBundleTask loadBundle(@NonNull InputStream bundleData) {
        LoadBundleTask resultTask = new LoadBundleTask();
        this.clientProvider.procedure((Consumer<FirestoreClient>)((Consumer)client -> client.loadBundle(bundleData, resultTask)));
        return resultTask;
    }

    @NonNull
    public LoadBundleTask loadBundle(@NonNull byte[] bundleData) {
        return this.loadBundle(new ByteArrayInputStream(bundleData));
    }

    @NonNull
    public LoadBundleTask loadBundle(@NonNull ByteBuffer bundleData) {
        return this.loadBundle(new ByteBufferInputStream(bundleData));
    }

    @SuppressLint(value={"TaskMainThread"})
    @NonNull
    public Task<com.google.firebase.firestore.Query> getNamedQuery(@NonNull String name) {
        return ((Task)this.clientProvider.call(client -> client.getNamedQuery(name))).continueWith(task -> {
            Query query = (Query)task.getResult();
            if (query != null) {
                return new com.google.firebase.firestore.Query(query, this);
            }
            return null;
        });
    }

    private ListenerRegistration addSnapshotsInSyncListener(Executor userExecutor, @Nullable Activity activity, @NonNull Runnable runnable) {
        EventListener<Void> eventListener = (v, error) -> {
            Assert.hardAssert(error == null, "snapshots-in-sync listeners should never get errors.", new Object[0]);
            runnable.run();
        };
        AsyncEventListener<Void> asyncListener = new AsyncEventListener<Void>(userExecutor, eventListener);
        return (ListenerRegistration)this.clientProvider.call(client -> {
            client.addSnapshotsInSyncListener(asyncListener);
            return ActivityScope.bind(activity, () -> {
                asyncListener.mute();
                client.removeSnapshotsInSyncListener(asyncListener);
            });
        });
    }

    <T> T callClient(Function<FirestoreClient, T> call) {
        return this.clientProvider.call(call);
    }

    DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    UserDataReader getUserDataReader() {
        return this.userDataReader;
    }

    void validateReference(DocumentReference docRef) {
        Preconditions.checkNotNull(docRef, "Provided DocumentReference must not be null.");
        if (docRef.getFirestore() != this) {
            throw new IllegalArgumentException("Provided document reference is from a different Cloud Firestore instance.");
        }
    }

    @Keep
    static void setClientLanguage(@NonNull String languageToken) {
        FirestoreChannel.setClientLanguage(languageToken);
    }

    public static interface InstanceRegistry {
        public void remove(@NonNull String var1);
    }
}

