/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import android.net.Uri;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentId;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.Exclude;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.IgnoreExtraProperties;
import com.google.firebase.firestore.PropertyName;
import com.google.firebase.firestore.ServerTimestamp;
import com.google.firebase.firestore.ThrowOnExtraProperties;
import com.google.firebase.firestore.util.ApiUtil;
import com.google.firebase.firestore.util.Logger;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CustomClassMapper {
    private static final int MAX_DEPTH = 500;
    private static final ConcurrentMap<Class<?>, BeanMapper<?>> mappers = new ConcurrentHashMap();

    private static void hardAssert(boolean assertion) {
        CustomClassMapper.hardAssert(assertion, "Internal inconsistency");
    }

    private static void hardAssert(boolean assertion, String message) {
        if (!assertion) {
            throw new RuntimeException("Hard assert failed: " + message);
        }
    }

    public static Object convertToPlainJavaTypes(Object object) {
        return CustomClassMapper.serialize(object);
    }

    public static Map<String, Object> convertToPlainJavaTypes(Map<?, Object> update) {
        Object converted = CustomClassMapper.serialize(update);
        CustomClassMapper.hardAssert(converted instanceof Map);
        Map convertedMap = (Map)converted;
        return convertedMap;
    }

    public static <T> T convertToCustomClass(Object object, Class<T> clazz, DocumentReference docRef) {
        return CustomClassMapper.deserializeToClass(object, clazz, new DeserializeContext(ErrorPath.EMPTY, docRef));
    }

    private static <T> Object serialize(T o) {
        return CustomClassMapper.serialize(o, ErrorPath.EMPTY);
    }

    private static <T> Object serialize(T o, ErrorPath path) {
        if (path.getLength() > 500) {
            throw CustomClassMapper.serializeError(path, "Exceeded maximum depth of 500, which likely indicates there's an object cycle");
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            if (o instanceof Long || o instanceof Integer || o instanceof Double || o instanceof Float) {
                return o;
            }
            throw CustomClassMapper.serializeError(path, String.format("Numbers of type %s are not supported, please use an int, long, float or double", o.getClass().getSimpleName()));
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof Boolean) {
            return o;
        }
        if (o instanceof Character) {
            throw CustomClassMapper.serializeError(path, "Characters are not supported, please use Strings");
        }
        if (o instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    String keyString = (String)key;
                    result.put(keyString, CustomClassMapper.serialize(entry.getValue(), path.child(keyString)));
                    continue;
                }
                throw CustomClassMapper.serializeError(path, "Maps with non-string keys are not supported");
            }
            return result;
        }
        if (o instanceof Collection) {
            if (o instanceof List) {
                List list = (List)o;
                ArrayList<Object> result = new ArrayList<Object>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    result.add(CustomClassMapper.serialize(list.get(i), path.child("[" + i + "]")));
                }
                return result;
            }
            throw CustomClassMapper.serializeError(path, "Serializing Collections is not supported, please use Lists instead");
        }
        if (o.getClass().isArray()) {
            throw CustomClassMapper.serializeError(path, "Serializing Arrays is not supported, please use Lists instead");
        }
        if (o instanceof Enum) {
            String enumName = ((Enum)o).name();
            try {
                Field enumField = o.getClass().getField(enumName);
                return BeanMapper.propertyName(enumField);
            }
            catch (NoSuchFieldException ex) {
                return enumName;
            }
        }
        if (o instanceof Date || o instanceof Timestamp || o instanceof GeoPoint || o instanceof Blob || o instanceof DocumentReference || o instanceof FieldValue) {
            return o;
        }
        if (o instanceof Uri || o instanceof URI || o instanceof URL) {
            return o.toString();
        }
        Class<?> clazz = o.getClass();
        BeanMapper<?> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        return mapper.serialize(o, path);
    }

    private static <T> T deserializeToType(Object o, Type type, DeserializeContext context) {
        if (o == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return CustomClassMapper.deserializeToParameterizedType(o, (ParameterizedType)type, context);
        }
        if (type instanceof Class) {
            return CustomClassMapper.deserializeToClass(o, (Class)type, context);
        }
        if (type instanceof WildcardType) {
            Type[] lowerBounds = ((WildcardType)type).getLowerBounds();
            if (lowerBounds.length > 0) {
                throw CustomClassMapper.deserializeError(context.errorPath, "Generic lower-bounded wildcard types are not supported");
            }
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            CustomClassMapper.hardAssert(upperBounds.length > 0, "Unexpected type bounds on wildcard " + type);
            return CustomClassMapper.deserializeToType(o, upperBounds[0], context);
        }
        if (type instanceof TypeVariable) {
            Type[] upperBounds = ((TypeVariable)type).getBounds();
            CustomClassMapper.hardAssert(upperBounds.length > 0, "Unexpected type bounds on type variable " + type);
            return CustomClassMapper.deserializeToType(o, upperBounds[0], context);
        }
        if (type instanceof GenericArrayType) {
            throw CustomClassMapper.deserializeError(context.errorPath, "Generic Arrays are not supported, please use Lists instead");
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Unknown type encountered: " + type);
    }

    private static <T> T deserializeToClass(Object o, Class<T> clazz, DeserializeContext context) {
        if (o == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            return CustomClassMapper.deserializeToPrimitive(o, clazz, context);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertString(o, context);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDate(o, context);
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertTimestamp(o, context);
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertBlob(o, context);
        }
        if (GeoPoint.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertGeoPoint(o, context);
        }
        if (DocumentReference.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDocumentReference(o, context);
        }
        if (clazz.isArray()) {
            throw CustomClassMapper.deserializeError(context.errorPath, "Converting to Arrays is not supported, please use Lists instead");
        }
        if (clazz.getTypeParameters().length > 0) {
            throw CustomClassMapper.deserializeError(context.errorPath, "Class " + clazz.getName() + " has generic type parameters, please use GenericTypeIndicator instead");
        }
        if (clazz.equals(Object.class)) {
            return (T)o;
        }
        if (clazz.isEnum()) {
            return CustomClassMapper.deserializeToEnum(o, clazz, context);
        }
        return CustomClassMapper.convertBean(o, clazz, context);
    }

    private static <T> T deserializeToParameterizedType(Object o, ParameterizedType type, DeserializeContext context) {
        Class rawType = (Class)type.getRawType();
        if (List.class.isAssignableFrom(rawType)) {
            Type genericType = type.getActualTypeArguments()[0];
            if (o instanceof List) {
                List list = (List)o;
                ArrayList<T> result = new ArrayList<T>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    result.add(CustomClassMapper.deserializeToType(list.get(i), genericType, context.newInstanceWithErrorPath(context.errorPath.child("[" + i + "]"))));
                }
                return (T)result;
            }
            throw CustomClassMapper.deserializeError(context.errorPath, "Expected a List, but got a " + o.getClass());
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (!keyType.equals(String.class)) {
                throw CustomClassMapper.deserializeError(context.errorPath, "Only Maps with string keys are supported, but found Map with key type " + keyType);
            }
            Map<String, Object> map = CustomClassMapper.expectMap(o, context);
            HashMap<String, T> result = new HashMap<String, T>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                result.put(entry.getKey(), CustomClassMapper.deserializeToType(entry.getValue(), valueType, context.newInstanceWithErrorPath(context.errorPath.child(entry.getKey()))));
            }
            return (T)result;
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            throw CustomClassMapper.deserializeError(context.errorPath, "Collections are not supported, please use Lists instead");
        }
        Map<String, Object> map = CustomClassMapper.expectMap(o, context);
        BeanMapper mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(rawType);
        HashMap typeMapping = new HashMap();
        TypeVariable<Class<T>>[] typeVariables = mapper.clazz.getTypeParameters();
        Type[] types = type.getActualTypeArguments();
        if (types.length != typeVariables.length) {
            throw new IllegalStateException("Mismatched lengths for type variables and actual types");
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            typeMapping.put(typeVariables[i], types[i]);
        }
        return mapper.deserialize(map, typeMapping, context);
    }

    private static <T> T deserializeToPrimitive(Object o, Class<T> clazz, DeserializeContext context) {
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertInteger(o, context);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertBoolean(o, context);
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDouble(o, context);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertLong(o, context);
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return (T)Float.valueOf(CustomClassMapper.convertDouble(o, context).floatValue());
        }
        throw CustomClassMapper.deserializeError(context.errorPath, String.format("Deserializing values to %s is not supported", clazz.getSimpleName()));
    }

    private static <T> T deserializeToEnum(Object object, Class<T> clazz, DeserializeContext context) {
        if (object instanceof String) {
            Field[] enumFields;
            String value = (String)object;
            for (Field field : enumFields = clazz.getFields()) {
                String propertyName;
                if (!field.isEnumConstant() || !value.equals(propertyName = BeanMapper.propertyName(field))) continue;
                value = field.getName();
                break;
            }
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                throw CustomClassMapper.deserializeError(context.errorPath, "Could not find enum value of " + clazz.getName() + " for value \"" + value + "\"");
            }
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Expected a String while deserializing to enum " + clazz + " but got a " + object.getClass());
    }

    private static <T> BeanMapper<T> loadOrCreateBeanMapperForClass(Class<T> clazz) {
        BeanMapper<T> mapper = (BeanMapper<T>)mappers.get(clazz);
        if (mapper == null) {
            mapper = new BeanMapper<T>(clazz);
            mappers.put(clazz, mapper);
        }
        return mapper;
    }

    private static Map<String, Object> expectMap(Object object, DeserializeContext context) {
        if (object instanceof Map) {
            return (Map)object;
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Expected a Map while deserializing, but got a " + object.getClass());
    }

    private static Integer convertInteger(Object o, DeserializeContext context) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long || o instanceof Double) {
            double value = ((Number)o).doubleValue();
            if (value >= -2.147483648E9 && value <= 2.147483647E9) {
                return ((Number)o).intValue();
            }
            throw CustomClassMapper.deserializeError(context.errorPath, "Numeric value out of 32-bit integer range: " + value + ". Did you mean to use a long or double instead of an int?");
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert a value of type " + o.getClass().getName() + " to int");
    }

    private static Long convertLong(Object o, DeserializeContext context) {
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Double) {
            Double value = (Double)o;
            if (value >= -9.223372036854776E18 && value <= 9.223372036854776E18) {
                return value.longValue();
            }
            throw CustomClassMapper.deserializeError(context.errorPath, "Numeric value out of 64-bit long range: " + value + ". Did you mean to use a double instead of a long?");
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert a value of type " + o.getClass().getName() + " to long");
    }

    private static Double convertDouble(Object o, DeserializeContext context) {
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Long) {
            Long value = (Long)o;
            Double doubleValue = ((Long)o).doubleValue();
            if (doubleValue.longValue() == value.longValue()) {
                return doubleValue;
            }
            throw CustomClassMapper.deserializeError(context.errorPath, "Loss of precision while converting number to double: " + o + ". Did you mean to use a 64-bit long instead?");
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert a value of type " + o.getClass().getName() + " to double");
    }

    private static Boolean convertBoolean(Object o, DeserializeContext context) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert value of type " + o.getClass().getName() + " to boolean");
    }

    private static String convertString(Object o, DeserializeContext context) {
        if (o instanceof String) {
            return (String)o;
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert value of type " + o.getClass().getName() + " to String");
    }

    private static Date convertDate(Object o, DeserializeContext context) {
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Timestamp) {
            return ((Timestamp)o).toDate();
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert value of type " + o.getClass().getName() + " to Date");
    }

    private static Timestamp convertTimestamp(Object o, DeserializeContext context) {
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o instanceof Date) {
            return new Timestamp((Date)o);
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert value of type " + o.getClass().getName() + " to Timestamp");
    }

    private static Blob convertBlob(Object o, DeserializeContext context) {
        if (o instanceof Blob) {
            return (Blob)o;
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert value of type " + o.getClass().getName() + " to Blob");
    }

    private static GeoPoint convertGeoPoint(Object o, DeserializeContext context) {
        if (o instanceof GeoPoint) {
            return (GeoPoint)o;
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert value of type " + o.getClass().getName() + " to GeoPoint");
    }

    private static DocumentReference convertDocumentReference(Object o, DeserializeContext context) {
        if (o instanceof DocumentReference) {
            return (DocumentReference)o;
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Failed to convert value of type " + o.getClass().getName() + " to DocumentReference");
    }

    private static <T> T convertBean(Object o, Class<T> clazz, DeserializeContext context) {
        BeanMapper<T> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        if (o instanceof Map) {
            return mapper.deserialize(CustomClassMapper.expectMap(o, context), context);
        }
        throw CustomClassMapper.deserializeError(context.errorPath, "Can't convert object of type " + o.getClass().getName() + " to type " + clazz.getName());
    }

    private static IllegalArgumentException serializeError(ErrorPath path, String reason) {
        reason = "Could not serialize object. " + reason;
        if (path.getLength() > 0) {
            reason = reason + " (found in field '" + path.toString() + "')";
        }
        return new IllegalArgumentException(reason);
    }

    private static RuntimeException deserializeError(ErrorPath path, String reason) {
        reason = "Could not deserialize object. " + reason;
        if (path.getLength() > 0) {
            reason = reason + " (found in field '" + path.toString() + "')";
        }
        return new RuntimeException(reason);
    }

    static class DeserializeContext {
        final ErrorPath errorPath;
        final DocumentReference documentRef;

        DeserializeContext(ErrorPath path, DocumentReference docRef) {
            this.errorPath = path;
            this.documentRef = docRef;
        }

        DeserializeContext newInstanceWithErrorPath(ErrorPath newPath) {
            return new DeserializeContext(newPath, this.documentRef);
        }
    }

    static class ErrorPath {
        private final int length;
        private final ErrorPath parent;
        private final String name;
        static final ErrorPath EMPTY = new ErrorPath(null, null, 0);

        ErrorPath(ErrorPath parent, String name, int length) {
            this.parent = parent;
            this.name = name;
            this.length = length;
        }

        int getLength() {
            return this.length;
        }

        ErrorPath child(String name) {
            return new ErrorPath(this, name, this.length + 1);
        }

        public String toString() {
            if (this.length == 0) {
                return "";
            }
            if (this.length == 1) {
                return this.name;
            }
            return this.parent.toString() + "." + this.name;
        }
    }

    private static class BeanMapper<T> {
        private final Class<T> clazz;
        private final Constructor<T> constructor;
        private final boolean throwOnUnknownProperties;
        private final boolean warnOnUnknownProperties;
        private final Map<String, String> properties;
        private final Map<String, Method> getters;
        private final Map<String, Method> setters;
        private final Map<String, Field> fields;
        private final HashSet<String> serverTimestamps;
        private final HashSet<String> documentIdPropertyNames;

        /*
         * WARNING - void declaration
         */
        BeanMapper(Class<T> clazz) {
            Constructor<T> constructor;
            this.clazz = clazz;
            this.throwOnUnknownProperties = clazz.isAnnotationPresent(ThrowOnExtraProperties.class);
            this.warnOnUnknownProperties = !clazz.isAnnotationPresent(IgnoreExtraProperties.class);
            this.properties = new HashMap<String, String>();
            this.setters = new HashMap<String, Method>();
            this.getters = new HashMap<String, Method>();
            this.fields = new HashMap<String, Field>();
            this.serverTimestamps = new HashSet();
            this.documentIdPropertyNames = new HashSet();
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                constructor = null;
            }
            this.constructor = constructor;
            for (Method method : clazz.getMethods()) {
                if (!BeanMapper.shouldIncludeGetter(method)) continue;
                String string = BeanMapper.propertyName(method);
                this.addProperty(string);
                method.setAccessible(true);
                if (this.getters.containsKey(string)) {
                    throw new RuntimeException("Found conflicting getters for name " + method.getName() + " on class " + clazz.getName());
                }
                this.getters.put(string, method);
                this.applyGetterAnnotations(method);
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                if (!BeanMapper.shouldIncludeField((Field)accessibleObject)) continue;
                String string = BeanMapper.propertyName((Field)accessibleObject);
                this.addProperty(string);
                this.applyFieldAnnotations((Field)accessibleObject);
            }
            Class<T> currentClass = clazz;
            do {
                void var6_14;
                int n;
                Object object = currentClass.getDeclaredMethods();
                int n2 = ((Method[])object).length;
                boolean bl = false;
                while (n < n2) {
                    String propertyName2;
                    String existingPropertyName;
                    Method method = object[n];
                    if (BeanMapper.shouldIncludeSetter(method) && (existingPropertyName = this.properties.get((propertyName2 = BeanMapper.propertyName(method)).toLowerCase(Locale.US))) != null) {
                        if (!existingPropertyName.equals(propertyName2)) {
                            throw new RuntimeException("Found setter on " + currentClass.getName() + " with invalid case-sensitive name: " + method.getName());
                        }
                        Method existingSetter = this.setters.get(propertyName2);
                        if (existingSetter == null) {
                            method.setAccessible(true);
                            this.setters.put(propertyName2, method);
                            this.applySetterAnnotations(method);
                        } else if (!BeanMapper.isSetterOverride(method, existingSetter)) {
                            if (currentClass == clazz) {
                                throw new RuntimeException("Class " + clazz.getName() + " has multiple setter overloads with name " + method.getName());
                            }
                            throw new RuntimeException("Found conflicting setters with name: " + method.getName() + " (conflicts with " + existingSetter.getName() + " defined on " + existingSetter.getDeclaringClass().getName() + ")");
                        }
                    }
                    n += 1;
                }
                object = currentClass.getDeclaredFields();
                n2 = ((AccessibleObject[])object).length;
                n = 0;
                while (var6_14 < n2) {
                    AccessibleObject accessibleObject = object[var6_14];
                    String propertyName = BeanMapper.propertyName((Field)accessibleObject);
                    if (this.properties.containsKey(propertyName.toLowerCase(Locale.US)) && !this.fields.containsKey(propertyName)) {
                        ((Field)accessibleObject).setAccessible(true);
                        this.fields.put(propertyName, (Field)accessibleObject);
                        this.applyFieldAnnotations((Field)accessibleObject);
                    }
                    ++var6_14;
                }
            } while ((currentClass = currentClass.getSuperclass()) != null && !currentClass.equals(Object.class));
            if (this.properties.isEmpty()) {
                throw new RuntimeException("No properties to serialize found on class " + clazz.getName());
            }
            for (String docIdProperty : this.documentIdPropertyNames) {
                if (this.setters.containsKey(docIdProperty) || this.fields.containsKey(docIdProperty)) continue;
                throw new RuntimeException("@DocumentId is annotated on property " + docIdProperty + " of class " + clazz.getName() + " but no field or public setter was found");
            }
        }

        private void addProperty(String property) {
            String oldValue = this.properties.put(property.toLowerCase(Locale.US), property);
            if (oldValue != null && !property.equals(oldValue)) {
                throw new RuntimeException("Found two getters or fields with conflicting case sensitivity for property: " + property.toLowerCase(Locale.US));
            }
        }

        T deserialize(Map<String, Object> values, DeserializeContext context) {
            return this.deserialize(values, Collections.emptyMap(), context);
        }

        T deserialize(Map<String, Object> values, Map<TypeVariable<Class<T>>, Type> types, DeserializeContext context) {
            if (this.constructor == null) {
                throw CustomClassMapper.deserializeError(context.errorPath, "Class " + this.clazz.getName() + " does not define a no-argument constructor. If you are using ProGuard, make sure these constructors are not stripped");
            }
            T instance = ApiUtil.newInstance(this.constructor);
            HashSet<String> deserialzedProperties = new HashSet<String>();
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                String propertyName = entry.getKey();
                ErrorPath childPath = context.errorPath.child(propertyName);
                if (this.setters.containsKey(propertyName)) {
                    Method setter = this.setters.get(propertyName);
                    Type[] params = setter.getGenericParameterTypes();
                    if (params.length != 1) {
                        throw CustomClassMapper.deserializeError(childPath, "Setter does not have exactly one parameter");
                    }
                    Type resolvedType = this.resolveType(params[0], types);
                    Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType, context.newInstanceWithErrorPath(childPath));
                    ApiUtil.invoke(setter, instance, value);
                    deserialzedProperties.add(propertyName);
                    continue;
                }
                if (this.fields.containsKey(propertyName)) {
                    Field field = this.fields.get(propertyName);
                    Type resolvedType = this.resolveType(field.getGenericType(), types);
                    Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType, context.newInstanceWithErrorPath(childPath));
                    try {
                        field.set(instance, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    deserialzedProperties.add(propertyName);
                    continue;
                }
                String message = "No setter/field for " + propertyName + " found on class " + this.clazz.getName();
                if (this.properties.containsKey(propertyName.toLowerCase(Locale.US))) {
                    message = message + " (fields/setters are case sensitive!)";
                }
                if (this.throwOnUnknownProperties) {
                    throw new RuntimeException(message);
                }
                if (!this.warnOnUnknownProperties) continue;
                Logger.warn(CustomClassMapper.class.getSimpleName(), "%s", message);
            }
            this.populateDocumentIdProperties(types, context, instance, deserialzedProperties);
            return instance;
        }

        private void populateDocumentIdProperties(Map<TypeVariable<Class<T>>, Type> types, DeserializeContext context, T instance, HashSet<String> deserialzedProperties) {
            for (String docIdPropertyName : this.documentIdPropertyNames) {
                if (deserialzedProperties.contains(docIdPropertyName)) {
                    String message = "'" + docIdPropertyName + "' was found from document " + context.documentRef.getPath() + ", cannot apply @DocumentId on this property for class " + this.clazz.getName();
                    throw new RuntimeException(message);
                }
                ErrorPath childPath = context.errorPath.child(docIdPropertyName);
                if (this.setters.containsKey(docIdPropertyName)) {
                    Method setter = this.setters.get(docIdPropertyName);
                    Type[] params = setter.getGenericParameterTypes();
                    if (params.length != 1) {
                        throw CustomClassMapper.deserializeError(childPath, "Setter does not have exactly one parameter");
                    }
                    Type resolvedType = this.resolveType(params[0], types);
                    if (resolvedType == String.class) {
                        ApiUtil.invoke(setter, instance, context.documentRef.getId());
                        continue;
                    }
                    ApiUtil.invoke(setter, instance, context.documentRef);
                    continue;
                }
                Field docIdField = this.fields.get(docIdPropertyName);
                try {
                    if (docIdField.getType() == String.class) {
                        docIdField.set(instance, context.documentRef.getId());
                        continue;
                    }
                    docIdField.set(instance, context.documentRef);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private Type resolveType(Type type, Map<TypeVariable<Class<T>>, Type> types) {
            if (type instanceof TypeVariable) {
                Type resolvedType = types.get(type);
                if (resolvedType == null) {
                    throw new IllegalStateException("Could not resolve type " + type);
                }
                return resolvedType;
            }
            return type;
        }

        Map<String, Object> serialize(T object, ErrorPath path) {
            if (!this.clazz.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("Can't serialize object of class " + object.getClass() + " with BeanMapper for class " + this.clazz);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String property : this.properties.values()) {
                Object propertyValue;
                if (this.documentIdPropertyNames.contains(property)) continue;
                if (this.getters.containsKey(property)) {
                    Method getter = this.getters.get(property);
                    propertyValue = ApiUtil.invoke(getter, object, new Object[0]);
                } else {
                    Field field = this.fields.get(property);
                    if (field == null) {
                        throw new IllegalStateException("Bean property without field or getter: " + property);
                    }
                    try {
                        propertyValue = field.get(object);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                Object serializedValue = this.serverTimestamps.contains(property) && propertyValue == null ? FieldValue.serverTimestamp() : CustomClassMapper.serialize(propertyValue, path.child(property));
                result.put(property, serializedValue);
            }
            return result;
        }

        private void applyFieldAnnotations(Field field) {
            Class<?> fieldType;
            if (field.isAnnotationPresent(ServerTimestamp.class)) {
                fieldType = field.getType();
                if (fieldType != Date.class && fieldType != Timestamp.class) {
                    throw new IllegalArgumentException("Field " + field.getName() + " is annotated with @ServerTimestamp but is " + fieldType + " instead of Date or Timestamp.");
                }
                this.serverTimestamps.add(BeanMapper.propertyName(field));
            }
            if (field.isAnnotationPresent(DocumentId.class)) {
                fieldType = field.getType();
                this.ensureValidDocumentIdType("Field", "is", fieldType);
                this.documentIdPropertyNames.add(BeanMapper.propertyName(field));
            }
        }

        private void applyGetterAnnotations(Method method) {
            Class<?> returnType;
            if (method.isAnnotationPresent(ServerTimestamp.class)) {
                returnType = method.getReturnType();
                if (returnType != Date.class && returnType != Timestamp.class) {
                    throw new IllegalArgumentException("Method " + method.getName() + " is annotated with @ServerTimestamp but returns " + returnType + " instead of Date or Timestamp.");
                }
                this.serverTimestamps.add(BeanMapper.propertyName(method));
            }
            if (method.isAnnotationPresent(DocumentId.class)) {
                returnType = method.getReturnType();
                this.ensureValidDocumentIdType("Method", "returns", returnType);
                this.documentIdPropertyNames.add(BeanMapper.propertyName(method));
            }
        }

        private void applySetterAnnotations(Method method) {
            if (method.isAnnotationPresent(ServerTimestamp.class)) {
                throw new IllegalArgumentException("Method " + method.getName() + " is annotated with @ServerTimestamp but should not be. @ServerTimestamp can only be applied to fields and getters, not setters.");
            }
            if (method.isAnnotationPresent(DocumentId.class)) {
                Class<?> paramType = method.getParameterTypes()[0];
                this.ensureValidDocumentIdType("Method", "accepts", paramType);
                this.documentIdPropertyNames.add(BeanMapper.propertyName(method));
            }
        }

        private void ensureValidDocumentIdType(String fieldDescription, String operation, Type type) {
            if (type != String.class && type != DocumentReference.class) {
                throw new IllegalArgumentException(fieldDescription + " is annotated with @DocumentId but " + operation + " " + type + " instead of String or DocumentReference.");
            }
        }

        private static boolean shouldIncludeGetter(Method method) {
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
                return false;
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 0) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean shouldIncludeSetter(Method method) {
            if (!method.getName().startsWith("set")) {
                return false;
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 1) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean shouldIncludeField(Field field) {
            if (field.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (!Modifier.isPublic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isTransient(field.getModifiers())) {
                return false;
            }
            return !field.isAnnotationPresent(Exclude.class);
        }

        private static boolean isSetterOverride(Method base, Method override) {
            CustomClassMapper.hardAssert(base.getDeclaringClass().isAssignableFrom(override.getDeclaringClass()), "Expected override from a base class");
            CustomClassMapper.hardAssert(base.getReturnType().equals(Void.TYPE), "Expected void return type");
            CustomClassMapper.hardAssert(override.getReturnType().equals(Void.TYPE), "Expected void return type");
            Class<?>[] baseParameterTypes = base.getParameterTypes();
            Class<?>[] overrideParameterTypes = override.getParameterTypes();
            CustomClassMapper.hardAssert(baseParameterTypes.length == 1, "Expected exactly one parameter");
            CustomClassMapper.hardAssert(overrideParameterTypes.length == 1, "Expected exactly one parameter");
            return base.getName().equals(override.getName()) && baseParameterTypes[0].equals(overrideParameterTypes[0]);
        }

        private static String propertyName(Field field) {
            String annotatedName = BeanMapper.annotatedName(field);
            return annotatedName != null ? annotatedName : field.getName();
        }

        private static String propertyName(Method method) {
            String annotatedName = BeanMapper.annotatedName(method);
            return annotatedName != null ? annotatedName : BeanMapper.serializedName(method.getName());
        }

        private static String annotatedName(AccessibleObject obj) {
            if (obj.isAnnotationPresent(PropertyName.class)) {
                PropertyName annotation = obj.getAnnotation(PropertyName.class);
                return annotation.value();
            }
            return null;
        }

        private static String serializedName(String methodName) {
            String[] prefixes = new String[]{"get", "set", "is"};
            String methodPrefix = null;
            for (String prefix : prefixes) {
                if (!methodName.startsWith(prefix)) continue;
                methodPrefix = prefix;
            }
            if (methodPrefix == null) {
                throw new IllegalArgumentException("Unknown Bean prefix for method: " + methodName);
            }
            String strippedName = methodName.substring(methodPrefix.length());
            char[] chars = strippedName.toCharArray();
            for (int pos = 0; pos < chars.length && Character.isUpperCase(chars[pos]); ++pos) {
                chars[pos] = Character.toLowerCase(chars[pos]);
            }
            return new String(chars);
        }
    }
}

