/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.local.DocumentOverlayCache;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.Overlay;
import com.google.firebase.firestore.util.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public class MemoryDocumentOverlayCache
implements DocumentOverlayCache {
    private final TreeMap<DocumentKey, Overlay> overlays = new TreeMap();
    private final Map<Integer, Set<DocumentKey>> overlayByBatchId = new HashMap<Integer, Set<DocumentKey>>();

    @Override
    @Nullable
    public Overlay getOverlay(DocumentKey key) {
        return this.overlays.get(key);
    }

    @Override
    public Map<DocumentKey, Overlay> getOverlays(SortedSet<DocumentKey> keys) {
        HashMap<DocumentKey, Overlay> result = new HashMap<DocumentKey, Overlay>();
        for (DocumentKey key : keys) {
            Overlay overlay = this.overlays.get(key);
            if (overlay == null) continue;
            result.put(key, overlay);
        }
        return result;
    }

    private void saveOverlay(int largestBatchId, Mutation mutation) {
        Overlay existing = this.overlays.get(mutation.getKey());
        if (existing != null) {
            this.overlayByBatchId.get(existing.getLargestBatchId()).remove(mutation.getKey());
        }
        this.overlays.put(mutation.getKey(), Overlay.create(largestBatchId, mutation));
        if (this.overlayByBatchId.get(largestBatchId) == null) {
            this.overlayByBatchId.put(largestBatchId, new HashSet());
        }
        this.overlayByBatchId.get(largestBatchId).add(mutation.getKey());
    }

    @Override
    public void saveOverlays(int largestBatchId, Map<DocumentKey, Mutation> overlays) {
        for (Map.Entry<DocumentKey, Mutation> entry : overlays.entrySet()) {
            Mutation overlay = Preconditions.checkNotNull(entry.getValue(), "null value for key: %s", entry.getKey());
            this.saveOverlay(largestBatchId, overlay);
        }
    }

    @Override
    public void removeOverlaysForBatchId(int batchId) {
        if (this.overlayByBatchId.containsKey(batchId)) {
            Set<DocumentKey> keys = this.overlayByBatchId.get(batchId);
            this.overlayByBatchId.remove(batchId);
            for (DocumentKey key : keys) {
                this.overlays.remove(key);
            }
        }
    }

    @Override
    public Map<DocumentKey, Overlay> getOverlays(ResourcePath collection, int sinceBatchId) {
        Overlay overlay;
        DocumentKey key;
        HashMap<DocumentKey, Overlay> result = new HashMap<DocumentKey, Overlay>();
        int immediateChildrenPathLength = collection.length() + 1;
        DocumentKey prefix = DocumentKey.fromPath((ResourcePath)((Object)collection.append("")));
        SortedMap<DocumentKey, Overlay> view = this.overlays.tailMap(prefix);
        Iterator iterator = view.values().iterator();
        while (iterator.hasNext() && collection.isPrefixOf((key = (overlay = (Overlay)iterator.next()).getKey()).getPath())) {
            if (key.getPath().length() != immediateChildrenPathLength || overlay.getLargestBatchId() <= sinceBatchId) continue;
            result.put(overlay.getKey(), overlay);
        }
        return result;
    }

    @Override
    public Map<DocumentKey, Overlay> getOverlays(String collectionGroup, int sinceBatchId, int count) {
        TreeMap<Integer, HashMap<DocumentKey, Overlay>> batchIdToOverlays = new TreeMap<Integer, HashMap<DocumentKey, Overlay>>();
        for (Overlay overlay : this.overlays.values()) {
            DocumentKey key = overlay.getKey();
            if (!key.getCollectionGroup().equals(collectionGroup) || overlay.getLargestBatchId() <= sinceBatchId) continue;
            HashMap<DocumentKey, Overlay> overlays = (HashMap<DocumentKey, Overlay>)batchIdToOverlays.get(overlay.getLargestBatchId());
            if (overlays == null) {
                overlays = new HashMap<DocumentKey, Overlay>();
                batchIdToOverlays.put(overlay.getLargestBatchId(), overlays);
            }
            overlays.put(overlay.getKey(), overlay);
        }
        HashMap<DocumentKey, Overlay> result = new HashMap<DocumentKey, Overlay>();
        for (Map overlays : batchIdToOverlays.values()) {
            result.putAll(overlays);
            if (result.size() < count) continue;
            break;
        }
        return result;
    }
}

