/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.index;

import com.google.firebase.firestore.index.IndexEntry;
import com.google.firebase.firestore.model.DocumentKey;
import java.util.Arrays;

final class AutoValue_IndexEntry
extends IndexEntry {
    private final int indexId;
    private final DocumentKey documentKey;
    private final byte[] arrayValue;
    private final byte[] directionalValue;

    AutoValue_IndexEntry(int indexId, DocumentKey documentKey, byte[] arrayValue, byte[] directionalValue) {
        this.indexId = indexId;
        if (documentKey == null) {
            throw new NullPointerException("Null documentKey");
        }
        this.documentKey = documentKey;
        if (arrayValue == null) {
            throw new NullPointerException("Null arrayValue");
        }
        this.arrayValue = arrayValue;
        if (directionalValue == null) {
            throw new NullPointerException("Null directionalValue");
        }
        this.directionalValue = directionalValue;
    }

    @Override
    public int getIndexId() {
        return this.indexId;
    }

    @Override
    public DocumentKey getDocumentKey() {
        return this.documentKey;
    }

    @Override
    public byte[] getArrayValue() {
        return this.arrayValue;
    }

    @Override
    public byte[] getDirectionalValue() {
        return this.directionalValue;
    }

    public String toString() {
        return "IndexEntry{indexId=" + this.indexId + ", documentKey=" + this.documentKey + ", arrayValue=" + Arrays.toString(this.arrayValue) + ", directionalValue=" + Arrays.toString(this.directionalValue) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexEntry) {
            IndexEntry that = (IndexEntry)o;
            return this.indexId == that.getIndexId() && this.documentKey.equals(that.getDocumentKey()) && Arrays.equals(this.arrayValue, that instanceof AutoValue_IndexEntry ? ((AutoValue_IndexEntry)that).arrayValue : that.getArrayValue()) && Arrays.equals(this.directionalValue, that instanceof AutoValue_IndexEntry ? ((AutoValue_IndexEntry)that).directionalValue : that.getDirectionalValue());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.indexId;
        h$ *= 1000003;
        h$ ^= this.documentKey.hashCode();
        h$ *= 1000003;
        h$ ^= Arrays.hashCode(this.arrayValue);
        h$ *= 1000003;
        return h$ ^= Arrays.hashCode(this.directionalValue);
    }
}

