/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firebase.firestore.util.Util;
import com.google.protobuf.ByteString;

public class Blob
implements Comparable<Blob> {
    private final ByteString bytes;

    private Blob(ByteString bytes) {
        this.bytes = bytes;
    }

    @NonNull
    public static Blob fromBytes(@NonNull byte[] bytes) {
        Preconditions.checkNotNull(bytes, "Provided bytes array must not be null.");
        return new Blob(ByteString.copyFrom((byte[])bytes));
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Blob fromByteString(@NonNull ByteString bytes) {
        Preconditions.checkNotNull(bytes, "Provided ByteString must not be null.");
        return new Blob(bytes);
    }

    @NonNull
    public byte[] toBytes() {
        return this.bytes.toByteArray();
    }

    @NonNull
    public String toString() {
        return "Blob { bytes=" + Util.toDebugString(this.bytes) + " }";
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ByteString toByteString() {
        return this.bytes;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Blob && this.bytes.equals((Object)((Blob)other).bytes);
    }

    public int hashCode() {
        return this.bytes.hashCode();
    }

    @Override
    public int compareTo(@NonNull Blob other) {
        return Util.compareByteStrings(this.bytes, other.bytes);
    }
}

