/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.model.value.ObjectValue;
import com.google.firebase.firestore.util.Assert;
import javax.annotation.Nullable;

public final class SetMutation
extends Mutation {
    private final ObjectValue value;

    public SetMutation(DocumentKey key, ObjectValue value, Precondition precondition) {
        super(key, precondition);
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetMutation that = (SetMutation)o;
        return this.hasSameKeyAndPrecondition(that) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.keyAndPreconditionHashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "SetMutation{" + this.keyAndPreconditionToString() + ", value=" + this.value + "}";
    }

    @Override
    public MaybeDocument applyToRemoteDocument(@Nullable MaybeDocument maybeDoc, MutationResult mutationResult) {
        this.verifyKeyMatches(maybeDoc);
        Assert.hardAssert(mutationResult.getTransformResults() == null, "Transform results received by SetMutation.", new Object[0]);
        SnapshotVersion version = mutationResult.getVersion();
        return new Document(this.getKey(), version, this.value, Document.DocumentState.COMMITTED_MUTATIONS);
    }

    @Override
    @Nullable
    public MaybeDocument applyToLocalView(@Nullable MaybeDocument maybeDoc, @Nullable MaybeDocument baseDoc, Timestamp localWriteTime) {
        this.verifyKeyMatches(maybeDoc);
        if (!this.getPrecondition().isValidFor(maybeDoc)) {
            return maybeDoc;
        }
        SnapshotVersion version = SetMutation.getPostMutationVersion(maybeDoc);
        return new Document(this.getKey(), version, this.value, Document.DocumentState.LOCAL_MUTATIONS);
    }

    public ObjectValue getValue() {
        return this.value;
    }
}

