/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import android.util.SparseArray;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.QueryCache;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.ReferenceDelegate;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.local.SQLiteQueryCache$$Lambda$1;
import com.google.firebase.firestore.local.SQLiteQueryCache$$Lambda$2;
import com.google.firebase.firestore.local.SQLiteQueryCache$$Lambda$3;
import com.google.firebase.firestore.local.SQLiteQueryCache$$Lambda$4;
import com.google.firebase.firestore.local.SQLiteQueryCache$$Lambda$5;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.proto.Target;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Consumer;
import com.google.protobuf.InvalidProtocolBufferException;
import javax.annotation.Nullable;

final class SQLiteQueryCache
implements QueryCache {
    private final SQLitePersistence db;
    private final LocalSerializer localSerializer;
    private int highestTargetId;
    private long lastListenSequenceNumber;
    private SnapshotVersion lastRemoteSnapshotVersion = SnapshotVersion.NONE;
    private long targetCount;

    SQLiteQueryCache(SQLitePersistence db, LocalSerializer localSerializer) {
        this.db = db;
        this.localSerializer = localSerializer;
    }

    void start() {
        int found = this.db.query("SELECT highest_target_id, highest_listen_sequence_number, last_remote_snapshot_version_seconds, last_remote_snapshot_version_nanos, target_count FROM target_globals LIMIT 1").first(SQLiteQueryCache$$Lambda$1.lambdaFactory$(this));
        Assert.hardAssert(found == 1, "Missing target_globals entry", new Object[0]);
    }

    @Override
    public int getHighestTargetId() {
        return this.highestTargetId;
    }

    @Override
    public long getHighestListenSequenceNumber() {
        return this.lastListenSequenceNumber;
    }

    @Override
    public long getTargetCount() {
        return this.targetCount;
    }

    @Override
    public void forEachTarget(Consumer<QueryData> consumer) {
        this.db.query("SELECT target_proto FROM targets").forEach(SQLiteQueryCache$$Lambda$2.lambdaFactory$(this, consumer));
    }

    @Override
    public SnapshotVersion getLastRemoteSnapshotVersion() {
        return this.lastRemoteSnapshotVersion;
    }

    @Override
    public void setLastRemoteSnapshotVersion(SnapshotVersion snapshotVersion) {
        this.lastRemoteSnapshotVersion = snapshotVersion;
        this.writeMetadata();
    }

    private void saveQueryData(QueryData queryData) {
        int targetId = queryData.getTargetId();
        String canonicalId = queryData.getQuery().getCanonicalId();
        Timestamp version = queryData.getSnapshotVersion().getTimestamp();
        Target targetProto = this.localSerializer.encodeQueryData(queryData);
        this.db.execute("INSERT OR REPLACE INTO targets (target_id, canonical_id, snapshot_version_seconds, snapshot_version_nanos, resume_token, last_listen_sequence_number, target_proto) VALUES (?, ?, ?, ?, ?, ?, ?)", targetId, canonicalId, version.getSeconds(), version.getNanoseconds(), queryData.getResumeToken().toByteArray(), queryData.getSequenceNumber(), targetProto.toByteArray());
    }

    private boolean updateMetadata(QueryData queryData) {
        boolean wasUpdated = false;
        if (queryData.getTargetId() > this.highestTargetId) {
            this.highestTargetId = queryData.getTargetId();
            wasUpdated = true;
        }
        if (queryData.getSequenceNumber() > this.lastListenSequenceNumber) {
            this.lastListenSequenceNumber = queryData.getSequenceNumber();
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public void addQueryData(QueryData queryData) {
        this.saveQueryData(queryData);
        this.updateMetadata(queryData);
        ++this.targetCount;
        this.writeMetadata();
    }

    @Override
    public void updateQueryData(QueryData queryData) {
        this.saveQueryData(queryData);
        if (this.updateMetadata(queryData)) {
            this.writeMetadata();
        }
    }

    private void writeMetadata() {
        this.db.execute("UPDATE target_globals SET highest_target_id = ?, highest_listen_sequence_number = ?, last_remote_snapshot_version_seconds = ?, last_remote_snapshot_version_nanos = ?, target_count = ?", this.highestTargetId, this.lastListenSequenceNumber, this.lastRemoteSnapshotVersion.getTimestamp().getSeconds(), this.lastRemoteSnapshotVersion.getTimestamp().getNanoseconds(), this.targetCount);
    }

    private void removeTarget(int targetId) {
        this.removeMatchingKeysForTargetId(targetId);
        this.db.execute("DELETE FROM targets WHERE target_id = ?", targetId);
        --this.targetCount;
    }

    @Override
    public void removeQueryData(QueryData queryData) {
        int targetId = queryData.getTargetId();
        this.removeTarget(targetId);
        this.writeMetadata();
    }

    int removeQueries(long upperBound, SparseArray<?> activeTargetIds) {
        int[] count = new int[1];
        this.db.query("SELECT target_id FROM targets WHERE last_listen_sequence_number <= ?").binding(upperBound).forEach(SQLiteQueryCache$$Lambda$3.lambdaFactory$(this, activeTargetIds, count));
        this.writeMetadata();
        return count[0];
    }

    @Override
    @Nullable
    public QueryData getQueryData(Query query) {
        String canonicalId = query.getCanonicalId();
        QueryDataHolder result = new QueryDataHolder();
        this.db.query("SELECT target_proto FROM targets WHERE canonical_id = ?").binding(canonicalId).forEach(SQLiteQueryCache$$Lambda$4.lambdaFactory$(this, query, result));
        return result.queryData;
    }

    private QueryData decodeQueryData(byte[] bytes) {
        try {
            return this.localSerializer.decodeQueryData(Target.parseFrom(bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw Assert.fail("QueryData failed to parse: %s", new Object[]{e});
        }
    }

    @Override
    public void addMatchingKeys(ImmutableSortedSet<DocumentKey> keys, int targetId) {
        SQLiteStatement inserter = this.db.prepare("INSERT OR IGNORE INTO target_documents (target_id, path) VALUES (?, ?)");
        ReferenceDelegate delegate = this.db.getReferenceDelegate();
        for (DocumentKey key : keys) {
            String path = EncodedPath.encode(key.getPath());
            this.db.execute(inserter, targetId, path);
            delegate.addReference(key);
        }
    }

    @Override
    public void removeMatchingKeys(ImmutableSortedSet<DocumentKey> keys, int targetId) {
        SQLiteStatement deleter = this.db.prepare("DELETE FROM target_documents WHERE target_id = ? AND path = ?");
        ReferenceDelegate delegate = this.db.getReferenceDelegate();
        for (DocumentKey key : keys) {
            String path = EncodedPath.encode(key.getPath());
            this.db.execute(deleter, targetId, path);
            delegate.removeReference(key);
        }
    }

    private void removeMatchingKeysForTargetId(int targetId) {
        this.db.execute("DELETE FROM target_documents WHERE target_id = ?", targetId);
    }

    @Override
    public ImmutableSortedSet<DocumentKey> getMatchingKeysForTargetId(int targetId) {
        DocumentKeysHolder holder = new DocumentKeysHolder();
        this.db.query("SELECT path FROM target_documents WHERE target_id = ?").binding(targetId).forEach(SQLiteQueryCache$$Lambda$5.lambdaFactory$(holder));
        return holder.keys;
    }

    @Override
    public boolean containsKey(DocumentKey key) {
        String path = EncodedPath.encode(key.getPath());
        return !this.db.query("SELECT target_id FROM target_documents WHERE path = ? AND target_id != 0 LIMIT 1").binding(path).isEmpty();
    }

    static /* synthetic */ void lambda$getMatchingKeysForTargetId$4(DocumentKeysHolder holder, Cursor row) {
        String path = row.getString(0);
        DocumentKey key = DocumentKey.fromPath(EncodedPath.decodeResourcePath(path));
        holder.keys = holder.keys.insert((Object)key);
    }

    static /* synthetic */ void lambda$getQueryData$3(SQLiteQueryCache this_, Query query, QueryDataHolder result, Cursor row) {
        QueryData found = this_.decodeQueryData(row.getBlob(0));
        if (query.equals(found.getQuery())) {
            result.queryData = found;
        }
    }

    static /* synthetic */ void lambda$removeQueries$2(SQLiteQueryCache this_, SparseArray activeTargetIds, int[] count, Cursor row) {
        int targetId = row.getInt(0);
        if (activeTargetIds.get(targetId) == null) {
            this_.removeTarget(targetId);
            count[0] = count[0] + 1;
        }
    }

    static /* synthetic */ void lambda$forEachTarget$1(SQLiteQueryCache this_, Consumer consumer, Cursor row) {
        consumer.accept(this_.decodeQueryData(row.getBlob(0)));
    }

    static /* synthetic */ void lambda$start$0(SQLiteQueryCache this_, Cursor row) {
        this_.highestTargetId = row.getInt(0);
        this_.lastListenSequenceNumber = row.getInt(1);
        this_.lastRemoteSnapshotVersion = new SnapshotVersion(new Timestamp(row.getLong(2), row.getInt(3)));
        this_.targetCount = row.getLong(4);
    }

    private static class DocumentKeysHolder {
        ImmutableSortedSet<DocumentKey> keys = DocumentKey.emptyKeySet();

        private DocumentKeysHolder() {
        }
    }

    private static class QueryDataHolder {
        QueryData queryData;

        private QueryDataHolder() {
        }
    }
}

