/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.ArrayValue;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.util.Assert;

public class RelationFilter
extends Filter {
    private final Filter.Operator operator;
    private final FieldValue value;
    private final FieldPath field;

    RelationFilter(FieldPath field, Filter.Operator operator, FieldValue value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    public Filter.Operator getOperator() {
        return this.operator;
    }

    @Override
    public FieldPath getField() {
        return this.field;
    }

    public FieldValue getValue() {
        return this.value;
    }

    @Override
    public boolean matches(Document doc) {
        if (this.field.isKeyField()) {
            Object refValue = this.value.value();
            Assert.hardAssert(refValue instanceof DocumentKey, "Comparing on key, but filter value not a DocumentKey", new Object[0]);
            Assert.hardAssert(this.operator != Filter.Operator.ARRAY_CONTAINS, "ARRAY_CONTAINS queries don't make sense on document keys.", new Object[0]);
            int comparison = DocumentKey.comparator().compare(doc.getKey(), (DocumentKey)refValue);
            return this.matchesComparison(comparison);
        }
        FieldValue value = doc.getField(this.field);
        return value != null && this.matchesValue(doc.getField(this.field));
    }

    private boolean matchesValue(FieldValue other) {
        if (this.operator == Filter.Operator.ARRAY_CONTAINS) {
            return other instanceof ArrayValue && ((ArrayValue)other).getInternalValue().contains(this.value);
        }
        return this.value.typeOrder() == other.typeOrder() && this.matchesComparison(other.compareTo(this.value));
    }

    private boolean matchesComparison(int comp) {
        switch (this.operator) {
            case LESS_THAN: {
                return comp < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return comp <= 0;
            }
            case EQUAL: {
                return comp == 0;
            }
            case GREATER_THAN: {
                return comp > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return comp >= 0;
            }
        }
        throw Assert.fail("Unknown operator: %s", new Object[]{this.operator});
    }

    public boolean isInequality() {
        return this.operator != Filter.Operator.EQUAL && this.operator != Filter.Operator.ARRAY_CONTAINS;
    }

    @Override
    public String getCanonicalId() {
        return this.getField().canonicalString() + this.getOperator().toString() + this.getValue().toString();
    }

    public String toString() {
        return this.field.canonicalString() + " " + (Object)((Object)this.operator) + " " + this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RelationFilter)) {
            return false;
        }
        RelationFilter other = (RelationFilter)o;
        return this.operator == other.operator && this.field.equals(other.field) && this.value.equals(other.value);
    }

    public int hashCode() {
        int result = 37;
        result = 31 * result + this.operator.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

