/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import android.support.annotation.Nullable;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.util.Assert;

public class IndexRange {
    @Nullable
    private final FieldValue start;
    @Nullable
    private final FieldValue end;
    private final FieldPath fieldPath;

    private IndexRange(Builder builder) {
        this.fieldPath = builder.fieldPath;
        this.start = builder.start;
        this.end = builder.end;
    }

    public FieldPath getFieldPath() {
        return this.fieldPath;
    }

    @Nullable
    public FieldValue getStart() {
        return this.start;
    }

    @Nullable
    public FieldValue getEnd() {
        return this.end;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FieldPath fieldPath;
        private FieldValue start;
        private FieldValue end;

        public Builder setFieldPath(FieldPath fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        public Builder setStart(FieldValue start) {
            this.start = start;
            return this;
        }

        public Builder setEnd(FieldValue end) {
            this.end = end;
            return this;
        }

        public IndexRange build() {
            Assert.hardAssert(this.fieldPath != null, "Field path must be specified", new Object[0]);
            return new IndexRange(this);
        }
    }
}

