/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.firebase.annotations.PublicApi;
import java.util.Arrays;
import java.util.List;

@PublicApi
public abstract class FieldValue {
    private static final DeleteFieldValue DELETE_INSTANCE = new DeleteFieldValue();
    private static final ServerTimestampFieldValue SERVER_TIMESTAMP_INSTANCE = new ServerTimestampFieldValue();

    FieldValue() {
    }

    abstract String getMethodName();

    @NonNull
    @PublicApi
    public static FieldValue delete() {
        return DELETE_INSTANCE;
    }

    @NonNull
    @PublicApi
    public static FieldValue serverTimestamp() {
        return SERVER_TIMESTAMP_INSTANCE;
    }

    @NonNull
    @PublicApi
    public static FieldValue arrayUnion(Object ... elements) {
        return new ArrayUnionFieldValue(Arrays.asList(elements));
    }

    @NonNull
    @PublicApi
    public static FieldValue arrayRemove(Object ... elements) {
        return new ArrayRemoveFieldValue(Arrays.asList(elements));
    }

    static class ArrayRemoveFieldValue
    extends FieldValue {
        private final List<Object> elements;

        ArrayRemoveFieldValue(List<Object> elements) {
            this.elements = elements;
        }

        @Override
        String getMethodName() {
            return "FieldValue.arrayRemove";
        }

        List<Object> getElements() {
            return this.elements;
        }
    }

    static class ArrayUnionFieldValue
    extends FieldValue {
        private final List<Object> elements;

        ArrayUnionFieldValue(List<Object> elements) {
            this.elements = elements;
        }

        @Override
        String getMethodName() {
            return "FieldValue.arrayUnion";
        }

        List<Object> getElements() {
            return this.elements;
        }
    }

    static class ServerTimestampFieldValue
    extends FieldValue {
        ServerTimestampFieldValue() {
        }

        @Override
        String getMethodName() {
            return "FieldValue.serverTimestamp";
        }
    }

    static class DeleteFieldValue
    extends FieldValue {
        DeleteFieldValue() {
        }

        @Override
        String getMethodName() {
            return "FieldValue.delete";
        }
    }
}

