/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.util.Util;
import com.google.protobuf.ByteString;

@PublicApi
public class Blob
implements Comparable<Blob> {
    private final ByteString bytes;

    private Blob(ByteString bytes) {
        this.bytes = bytes;
    }

    @Keep
    @NonNull
    public static Blob fromBytes(@NonNull byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"Provided bytes array must not be null.");
        return new Blob(ByteString.copyFrom((byte[])bytes));
    }

    @NonNull
    public static Blob fromByteString(@NonNull ByteString bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"Provided ByteString must not be null.");
        return new Blob(bytes);
    }

    @Keep
    @NonNull
    public byte[] toBytes() {
        return this.bytes.toByteArray();
    }

    @NonNull
    public String toString() {
        return "Blob { bytes=" + Util.toDebugString(this.bytes) + " }";
    }

    @NonNull
    public ByteString toByteString() {
        return this.bytes;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Blob && this.bytes.equals((Object)((Blob)other).bytes);
    }

    public int hashCode() {
        return this.bytes.hashCode();
    }

    @Override
    @PublicApi
    public int compareTo(@NonNull Blob other) {
        int size = Math.min(this.bytes.size(), other.bytes.size());
        for (int i = 0; i < size; ++i) {
            int otherByte;
            int thisByte = this.bytes.byteAt(i) & 0xFF;
            if (thisByte < (otherByte = other.bytes.byteAt(i) & 0xFF)) {
                return -1;
            }
            if (thisByte <= otherByte) continue;
            return 1;
        }
        return Util.compareIntegers(this.bytes.size(), other.bytes.size());
    }
}

