/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.number;

public class IndexNumberDecoder {
    private boolean resultNegative;
    private int resultExponent;
    private long resultSignificand;
    private String longResultRepProblemMessage;
    private String doubleResultRepProblemMessage;
    private long resultAsLong;
    private double resultAsDouble;

    public IndexNumberDecoder() {
        this.reset();
    }

    public void reset() {
        String noBytesDecodedMessage;
        this.longResultRepProblemMessage = noBytesDecodedMessage = "No bytes decoded.";
        this.doubleResultRepProblemMessage = noBytesDecodedMessage;
    }

    public boolean isResultLong() {
        this.updateResultLongState();
        return this.longResultRepProblemMessage.isEmpty();
    }

    public long resultAsLong() {
        this.updateResultLongState();
        if (!this.longResultRepProblemMessage.isEmpty()) {
            throw new IllegalArgumentException(this.longResultRepProblemMessage);
        }
        return this.resultAsLong;
    }

    public boolean isResultDouble() {
        this.updateResultDoubleState();
        return this.doubleResultRepProblemMessage.isEmpty();
    }

    private void updateResultLongState() {
        if (this.longResultRepProblemMessage != null) {
            return;
        }
        String resultNotInteger = "Number is not an integer.";
        String resultOutOfRange = "Number is outside the long range.";
        this.longResultRepProblemMessage = "";
        if (this.resultExponent == Integer.MAX_VALUE) {
            this.longResultRepProblemMessage = this.resultSignificand == 0L ? (this.resultNegative ? "+Infinity is not an integer." : "-Infinity is not an integer.") : "NaN is not an integer.";
            return;
        }
        if (this.resultExponent == Integer.MIN_VALUE && this.resultSignificand == 0L) {
            this.resultAsLong = 0L;
            return;
        }
        if (this.resultExponent < 0) {
            this.longResultRepProblemMessage = resultNotInteger;
        } else if (this.resultExponent >= 64) {
            this.longResultRepProblemMessage = resultOutOfRange;
        } else if (this.resultExponent == 63) {
            if (this.resultSignificand == 0L && this.resultNegative) {
                this.resultAsLong = Long.MIN_VALUE;
            } else {
                this.longResultRepProblemMessage = resultOutOfRange;
            }
        } else {
            int numSignicandBits = 64 - Long.numberOfTrailingZeros(this.resultSignificand);
            if (this.resultExponent < numSignicandBits) {
                this.longResultRepProblemMessage = resultNotInteger;
            } else {
                long longValue = this.resultSignificand;
                int leadingZeros = 63 - this.resultExponent;
                longValue >>>= leadingZeros + 1;
                longValue ^= 1L << this.resultExponent;
                if (this.resultNegative) {
                    longValue = -longValue;
                }
                this.resultAsLong = longValue;
            }
        }
    }

    public double resultAsDouble() {
        this.updateResultDoubleState();
        if (!this.doubleResultRepProblemMessage.isEmpty()) {
            throw new IllegalArgumentException(this.doubleResultRepProblemMessage);
        }
        return this.resultAsDouble;
    }

    private void updateResultDoubleState() {
        if (this.doubleResultRepProblemMessage != null) {
            return;
        }
        this.doubleResultRepProblemMessage = "";
        if (this.resultExponent == Integer.MAX_VALUE) {
            this.resultAsDouble = this.resultSignificand == 0L ? (this.resultNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY) : Double.NaN;
            return;
        }
        if (this.resultExponent == Integer.MIN_VALUE && this.resultSignificand == 0L) {
            this.resultAsDouble = 0.0;
            return;
        }
        int numSignicandBits = 64 - Long.numberOfTrailingZeros(this.resultSignificand);
        if (numSignicandBits > 52) {
            this.doubleResultRepProblemMessage = "Number has too many significant bits for a double.";
            return;
        }
        this.resultSignificand >>>= 12;
        if (this.resultExponent >= -1022) {
            this.resultExponent += 1023;
        } else {
            int adjustment = -1022 - this.resultExponent;
            long unadjustedSignificand = this.resultSignificand;
            this.resultSignificand >>>= adjustment;
            if (this.resultSignificand << adjustment != unadjustedSignificand) {
                this.doubleResultRepProblemMessage = "Number has too many significant bits for a subnormal double.";
            }
            this.resultSignificand |= 1L << 52 - adjustment;
            this.resultExponent = 0;
        }
        long doubleValueAsLong = this.resultSignificand;
        doubleValueAsLong |= (long)this.resultExponent << 52;
        this.resultAsDouble = Double.longBitsToDouble(doubleValueAsLong |= this.resultNegative ? Long.MIN_VALUE : 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int decode(boolean descending, byte[] buffer, int offset) {
        int exponent;
        int b;
        int bufferPos = offset;
        boolean invertEncoding = ((b = buffer[bufferPos++] & 0xFF) & 0x80) == 0;
        int inverter = invertEncoding ? 255 : 0;
        boolean negative = invertEncoding ^ descending;
        boolean exponentNegative = ((b ^= inverter) & 0x40) == 0;
        int exponentInverter = exponentNegative ? 255 : 0;
        long significand = 0L;
        int writeBit = 64;
        int marker = IndexNumberDecoder.decodeMarker(b ^ exponentInverter);
        switch (marker) {
            case -4: {
                if (exponentNegative) {
                    throw new IllegalArgumentException("Invalid encoded number: exponent negative zero is invalid");
                }
                exponent = 0;
                break;
            }
            case -3: 
            case -2: 
            case -1: {
                exponent = 4 + marker;
                int significandStart = exponent + 1;
                int significandMask = ~(-1 << significandStart) & 0x7E;
                significand |= (long)(b & significandMask) << (writeBit -= exponent) - 1;
                break;
            }
            case 1: {
                exponent = (b ^ exponentInverter) & 0xF;
                exponent += 4;
                b = buffer[bufferPos++] & 0xFF ^ inverter;
                significand |= IndexNumberDecoder.decodeTrailingSignificandByte(b, writeBit -= 7);
                break;
            }
            case 2: {
                exponent = ((b ^ exponentInverter) & 7) << 4;
                b = buffer[bufferPos++] & 0xFF ^ inverter;
                exponent |= (b ^ exponentInverter) >>> 4;
                exponent += 20;
                significand |= ((long)b & 0xFL) << (writeBit -= 4);
                b = buffer[bufferPos++] & 0xFF ^ inverter;
                significand |= IndexNumberDecoder.decodeTrailingSignificandByte(b, writeBit -= 7);
                break;
            }
            case 3: {
                exponent = ((b ^ exponentInverter) & 3) << 8;
                b = buffer[bufferPos++] & 0xFF ^ inverter;
                exponent |= b ^ exponentInverter;
                exponent += 148;
                b = buffer[bufferPos++] & 0xFF ^ inverter;
                significand |= IndexNumberDecoder.decodeTrailingSignificandByte(b, writeBit -= 7);
                break;
            }
            case 6: {
                if (invertEncoding) {
                    if (exponentNegative) {
                        this.recordNumber(negative, Integer.MIN_VALUE, 0L);
                        return bufferPos - offset;
                    } else if ((b = buffer[bufferPos++] & 0xFF) == 128) {
                        this.recordNumber(negative, Integer.MAX_VALUE, 0L);
                        return bufferPos - offset;
                    } else {
                        if (b != 96) throw new IllegalArgumentException("Invalid encoded byte array");
                        this.recordNumber(negative, Integer.MAX_VALUE, 1L);
                    }
                    return bufferPos - offset;
                } else if (exponentNegative) {
                    this.recordNumber(negative, Integer.MIN_VALUE, 0L);
                    return bufferPos - offset;
                } else {
                    this.recordNumber(negative, Integer.MAX_VALUE, 0L);
                }
                return bufferPos - offset;
            }
            default: {
                throw new IllegalArgumentException("Invalid encoded byte array");
            }
        }
        while ((b & 1) != 0) {
            b = buffer[bufferPos++] & 0xFF ^ inverter;
            if ((writeBit -= 7) >= 0) {
                significand |= IndexNumberDecoder.decodeTrailingSignificandByte(b, writeBit);
                continue;
            }
            significand |= (long)(b & 0xFE) >>> -(writeBit - 1);
            writeBit = 0;
            if ((b & 1) == 0) continue;
            throw new IllegalArgumentException("Invalid encoded byte array: overlong sequence");
        }
        if (exponentNegative) {
            exponent = -exponent;
        }
        this.recordNumber(negative, exponent, significand);
        return bufferPos - offset;
    }

    private void recordNumber(boolean negative, int exponent, long significand) {
        this.longResultRepProblemMessage = null;
        this.doubleResultRepProblemMessage = null;
        this.resultNegative = negative;
        this.resultExponent = exponent;
        this.resultSignificand = significand;
    }

    static int decodeMarker(int byteValue) {
        boolean leadingOne;
        boolean bl = leadingOne = (byteValue & 0x20) != 0;
        if (leadingOne) {
            byteValue ^= 0xFF;
        }
        int log2 = 31 - Integer.numberOfLeadingZeros(byteValue &= 0x3F);
        int leader = 5 - log2;
        return leadingOne ? leader : -leader;
    }

    private static long decodeTrailingSignificandByte(int value, int position) {
        return (long)(value & 0xFE) << position - 1;
    }
}

