/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class FieldDescriptor {
    private final String name;
    private final Map<Class<?>, Object> properties;

    private FieldDescriptor(String name, Map<Class<?>, Object> properties) {
        this.name = name;
        this.properties = properties;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public <T extends Annotation> T getProperty(@NonNull Class<T> type) {
        return (T)((Annotation)this.properties.get(type));
    }

    @NonNull
    public static FieldDescriptor of(@NonNull String name) {
        return new FieldDescriptor(name, Collections.emptyMap());
    }

    @NonNull
    public static Builder builder(@NonNull String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldDescriptor)) {
            return false;
        }
        FieldDescriptor that = (FieldDescriptor)o;
        return this.name.equals(that.name) && this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }

    @NonNull
    public String toString() {
        return "FieldDescriptor{name=" + this.name + ", properties=" + this.properties.values() + "}";
    }

    public static final class Builder {
        private final String name;
        private Map<Class<?>, Object> properties = null;

        Builder(String name) {
            this.name = name;
        }

        @NonNull
        public <T extends Annotation> Builder withProperty(@NonNull T value) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            this.properties.put(value.annotationType(), value);
            return this;
        }

        @NonNull
        public FieldDescriptor build() {
            return new FieldDescriptor(this.name, this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(this.properties)));
        }
    }
}

