/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.json;

import androidx.annotation.NonNull;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.ValueEncoderContext;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import com.google.firebase.encoders.json.JsonValueObjectEncoderContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class JsonDataEncoderBuilder
implements EncoderConfig<JsonDataEncoderBuilder> {
    private static final ObjectEncoder<Object> DEFAULT_FALLBACK_ENCODER = (o, ctx) -> {
        throw new EncodingException("Couldn't find encoder for type " + o.getClass().getCanonicalName());
    };
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders = new HashMap();
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders = new HashMap();
    private ObjectEncoder<Object> fallbackEncoder = DEFAULT_FALLBACK_ENCODER;
    private boolean ignoreNullValues = false;
    private static final ValueEncoder<String> STRING_ENCODER = (o, ctx) -> ctx.add(o);
    private static final ValueEncoder<Boolean> BOOLEAN_ENCODER = (o, ctx) -> ctx.add(o.booleanValue());
    private static final TimestampEncoder TIMESTAMP_ENCODER = new TimestampEncoder();

    public JsonDataEncoderBuilder() {
        this.registerEncoder((Class)String.class, (ValueEncoder)STRING_ENCODER);
        this.registerEncoder((Class)Boolean.class, (ValueEncoder)BOOLEAN_ENCODER);
        this.registerEncoder((Class)Date.class, TIMESTAMP_ENCODER);
    }

    @NonNull
    public <T> JsonDataEncoderBuilder registerEncoder(@NonNull Class<T> clazz, @NonNull ObjectEncoder<? super T> objectEncoder) {
        this.objectEncoders.put(clazz, objectEncoder);
        this.valueEncoders.remove(clazz);
        return this;
    }

    @NonNull
    public <T> JsonDataEncoderBuilder registerEncoder(@NonNull Class<T> clazz, @NonNull ValueEncoder<? super T> encoder) {
        this.valueEncoders.put(clazz, encoder);
        this.objectEncoders.remove(clazz);
        return this;
    }

    @NonNull
    public JsonDataEncoderBuilder registerFallbackEncoder(@NonNull ObjectEncoder<Object> fallbackEncoder) {
        this.fallbackEncoder = fallbackEncoder;
        return this;
    }

    @NonNull
    public JsonDataEncoderBuilder configureWith(@NonNull Configurator config) {
        config.configure((EncoderConfig)this);
        return this;
    }

    @NonNull
    public JsonDataEncoderBuilder ignoreNullValues(boolean ignore) {
        this.ignoreNullValues = ignore;
        return this;
    }

    @NonNull
    public DataEncoder build() {
        return new DataEncoder(){

            public void encode(@NonNull Object o, @NonNull Writer writer) throws IOException {
                JsonValueObjectEncoderContext encoderContext = new JsonValueObjectEncoderContext(writer, JsonDataEncoderBuilder.this.objectEncoders, JsonDataEncoderBuilder.this.valueEncoders, (ObjectEncoder<Object>)JsonDataEncoderBuilder.this.fallbackEncoder, JsonDataEncoderBuilder.this.ignoreNullValues);
                encoderContext.add(o, false);
                encoderContext.close();
            }

            public String encode(@NonNull Object o) {
                StringWriter stringWriter = new StringWriter();
                try {
                    this.encode(o, stringWriter);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return stringWriter.toString();
            }
        };
    }

    private static final class TimestampEncoder
    implements ValueEncoder<Date> {
        private static final DateFormat rfc339 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);

        private TimestampEncoder() {
        }

        public void encode(@NonNull Date o, @NonNull ValueEncoderContext ctx) throws IOException {
            ctx.add(rfc339.format(o));
        }

        static {
            rfc339.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }
}

