/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.internal.zzg;
import com.google.firebase.dynamiclinks.zza;

public final class DynamicLink {
    private final Bundle zzu;

    DynamicLink(Bundle bundle) {
        this.zzu = bundle;
    }

    public final Uri getUri() {
        Bundle bundle = this.zzu;
        zzg.zzb(bundle);
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (uri == null) {
            Uri.Builder builder = new Uri.Builder();
            Uri uri2 = Uri.parse((String)bundle.getString("domainUriPrefix"));
            builder.scheme(uri2.getScheme());
            builder.authority(uri2.getAuthority());
            builder.path(uri2.getPath());
            Bundle bundle2 = bundle.getBundle("parameters");
            for (String string : bundle2.keySet()) {
                Object object = bundle2.get(string);
                if (object == null) continue;
                builder.appendQueryParameter(string, object.toString());
            }
            uri = builder.build();
        }
        return uri;
    }

    public static final class NavigationInfoParameters {
        final Bundle zzv;

        private NavigationInfoParameters(Bundle bundle) {
            this.zzv = bundle;
        }

        /* synthetic */ NavigationInfoParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzv = new Bundle();

            public Builder() {
            }

            public final Builder setForcedRedirectEnabled(boolean bl) {
                this.zzv.putInt("efr", bl ? 1 : 0);
                return this;
            }

            public final NavigationInfoParameters build() {
                return new NavigationInfoParameters(this.zzv, null);
            }
        }
    }

    public static final class SocialMetaTagParameters {
        final Bundle zzv;

        private SocialMetaTagParameters(Bundle bundle) {
            this.zzv = bundle;
        }

        /* synthetic */ SocialMetaTagParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzv = new Bundle();

            public Builder() {
            }

            public final Builder setTitle(String string) {
                this.zzv.putString("st", string);
                return this;
            }

            public final Builder setDescription(String string) {
                this.zzv.putString("sd", string);
                return this;
            }

            public final Builder setImageUrl(Uri uri) {
                this.zzv.putParcelable("si", (Parcelable)uri);
                return this;
            }

            public final SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.zzv, null);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        final Bundle zzv;

        private ItunesConnectAnalyticsParameters(Bundle bundle) {
            this.zzv = bundle;
        }

        /* synthetic */ ItunesConnectAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzv = new Bundle();

            public Builder() {
            }

            public final Builder setProviderToken(String string) {
                this.zzv.putString("pt", string);
                return this;
            }

            public final Builder setAffiliateToken(String string) {
                this.zzv.putString("at", string);
                return this;
            }

            public final Builder setCampaignToken(String string) {
                this.zzv.putString("ct", string);
                return this;
            }

            public final ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.zzv, null);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        Bundle zzv;

        private GoogleAnalyticsParameters(Bundle bundle) {
            this.zzv = bundle;
        }

        /* synthetic */ GoogleAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzv = new Bundle();

            public Builder() {
            }

            public Builder(String string, String string2, String string3) {
                this.zzv.putString("utm_source", string);
                this.zzv.putString("utm_medium", string2);
                this.zzv.putString("utm_campaign", string3);
            }

            public final Builder setSource(String string) {
                this.zzv.putString("utm_source", string);
                return this;
            }

            public final Builder setMedium(String string) {
                this.zzv.putString("utm_medium", string);
                return this;
            }

            public final Builder setCampaign(String string) {
                this.zzv.putString("utm_campaign", string);
                return this;
            }

            public final Builder setTerm(String string) {
                this.zzv.putString("utm_term", string);
                return this;
            }

            public final Builder setContent(String string) {
                this.zzv.putString("utm_content", string);
                return this;
            }

            public final GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.zzv, null);
            }
        }
    }

    public static final class IosParameters {
        final Bundle zzv;

        private IosParameters(Bundle bundle) {
            this.zzv = bundle;
        }

        /* synthetic */ IosParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzv = new Bundle();

            public Builder(@NonNull String string) {
                this.zzv.putString("ibi", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzv.putParcelable("ifl", (Parcelable)uri);
                return this;
            }

            public final Builder setCustomScheme(String string) {
                this.zzv.putString("ius", string);
                return this;
            }

            public final Builder setIpadFallbackUrl(Uri uri) {
                this.zzv.putParcelable("ipfl", (Parcelable)uri);
                return this;
            }

            public final Builder setIpadBundleId(String string) {
                this.zzv.putString("ipbi", string);
                return this;
            }

            public final Builder setAppStoreId(String string) {
                this.zzv.putString("isi", string);
                return this;
            }

            public final Builder setMinimumVersion(String string) {
                this.zzv.putString("imv", string);
                return this;
            }

            public final IosParameters build() {
                return new IosParameters(this.zzv, null);
            }
        }
    }

    public static final class AndroidParameters {
        final Bundle zzv;

        private AndroidParameters(Bundle bundle) {
            this.zzv = bundle;
        }

        /* synthetic */ AndroidParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzv;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.zzv = new Bundle();
                this.zzv.putString("apn", FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String string) {
                this.zzv = new Bundle();
                this.zzv.putString("apn", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzv.putParcelable("afl", (Parcelable)uri);
                return this;
            }

            public final Builder setMinimumVersion(int n) {
                this.zzv.putInt("amv", n);
                return this;
            }

            public final AndroidParameters build() {
                return new AndroidParameters(this.zzv, null);
            }
        }
    }

    public static final class Builder {
        private final zzg zzw;
        private final Bundle zzu;
        private final Bundle zzx;

        public Builder(zzg zzg2) {
            this.zzw = zzg2;
            this.zzu = new Bundle();
            if (FirebaseApp.getInstance() != null) {
                this.zzu.putString("apiKey", FirebaseApp.getInstance().getOptions().getApiKey());
            }
            this.zzx = new Bundle();
            this.zzu.putBundle("parameters", this.zzx);
        }

        public final Builder setLongLink(@NonNull Uri uri) {
            this.zzu.putParcelable("dynamicLink", (Parcelable)uri);
            return this;
        }

        public final Builder setLink(@NonNull Uri uri) {
            this.zzx.putParcelable("link", (Parcelable)uri);
            return this;
        }

        @Deprecated
        public final Builder setDynamicLinkDomain(@NonNull String string) {
            if (!string.matches("(https:\\/\\/)?[a-z0-9]{3,}\\.app\\.goo\\.gl$") && !string.matches("(https:\\/\\/)?[a-z0-9]{3,}\\.page\\.link$")) {
                throw new IllegalArgumentException("Use setDomainUriPrefix() instead, setDynamicLinkDomain() is only applicable for *.page.link and *.app.goo.gl domains.");
            }
            this.zzu.putString("domain", string);
            String string2 = String.valueOf("https://");
            String string3 = String.valueOf(string);
            this.zzu.putString("domainUriPrefix", string3.length() != 0 ? string2.concat(string3) : new String(string2));
            return this;
        }

        public final Builder setDomainUriPrefix(@NonNull String string) {
            if (string.matches("(https:\\/\\/)?[a-z0-9]{3,}\\.app\\.goo\\.gl$") || string.matches("(https:\\/\\/)?[a-z0-9]{3,}\\.page\\.link$")) {
                this.zzu.putString("domain", string.replace("https://", ""));
            }
            this.zzu.putString("domainUriPrefix", string);
            return this;
        }

        public final Builder setAndroidParameters(AndroidParameters androidParameters) {
            this.zzx.putAll(androidParameters.zzv);
            return this;
        }

        public final Builder setIosParameters(IosParameters iosParameters) {
            this.zzx.putAll(iosParameters.zzv);
            return this;
        }

        public final Builder setGoogleAnalyticsParameters(GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.zzx.putAll(googleAnalyticsParameters.zzv);
            return this;
        }

        public final Builder setItunesConnectAnalyticsParameters(ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.zzx.putAll(itunesConnectAnalyticsParameters.zzv);
            return this;
        }

        public final Builder setSocialMetaTagParameters(SocialMetaTagParameters socialMetaTagParameters) {
            this.zzx.putAll(socialMetaTagParameters.zzv);
            return this;
        }

        public final Builder setNavigationInfoParameters(NavigationInfoParameters navigationInfoParameters) {
            this.zzx.putAll(navigationInfoParameters.zzv);
            return this;
        }

        public final DynamicLink buildDynamicLink() {
            zzg.zzb(this.zzu);
            return new DynamicLink(this.zzu);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink() {
            this.zzb();
            return this.zzw.zza(this.zzu);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink(int n) {
            this.zzb();
            this.zzu.putInt("suffix", n);
            return this.zzw.zza(this.zzu);
        }

        private final void zzb() {
            if (this.zzu.getString("apiKey") == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

