/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzepn;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.zza;

public final class DynamicLink {
    private final Bundle zznrw;

    DynamicLink(Bundle bundle) {
        this.zznrw = bundle;
    }

    public final Uri getUri() {
        Bundle bundle = this.zznrw;
        zzepn.zzag(bundle);
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (uri == null) {
            Uri.Builder builder = new Uri.Builder();
            builder.scheme("https");
            builder.authority(bundle.getString("domain"));
            Bundle bundle2 = bundle.getBundle("parameters");
            for (String string : bundle2.keySet()) {
                Object object = bundle2.get(string);
                if (object == null) continue;
                builder.appendQueryParameter(string, object.toString());
            }
            uri = builder.build();
        }
        return uri;
    }

    public static final class NavigationInfoParameters {
        final Bundle zzefr;

        private NavigationInfoParameters(Bundle bundle) {
            this.zzefr = bundle;
        }

        /* synthetic */ NavigationInfoParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzefr = new Bundle();

            public Builder() {
            }

            public final Builder setForcedRedirectEnabled(boolean bl) {
                this.zzefr.putInt("efr", bl ? 1 : 0);
                return this;
            }

            public final NavigationInfoParameters build() {
                return new NavigationInfoParameters(this.zzefr, null);
            }
        }
    }

    public static final class SocialMetaTagParameters {
        final Bundle zzefr;

        private SocialMetaTagParameters(Bundle bundle) {
            this.zzefr = bundle;
        }

        /* synthetic */ SocialMetaTagParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzefr = new Bundle();

            public Builder() {
            }

            public final Builder setTitle(String string) {
                this.zzefr.putString("st", string);
                return this;
            }

            public final Builder setDescription(String string) {
                this.zzefr.putString("sd", string);
                return this;
            }

            public final Builder setImageUrl(Uri uri) {
                this.zzefr.putParcelable("si", (Parcelable)uri);
                return this;
            }

            public final SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.zzefr, null);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        final Bundle zzefr;

        private ItunesConnectAnalyticsParameters(Bundle bundle) {
            this.zzefr = bundle;
        }

        /* synthetic */ ItunesConnectAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzefr = new Bundle();

            public Builder() {
            }

            public final Builder setProviderToken(String string) {
                this.zzefr.putString("pt", string);
                return this;
            }

            public final Builder setAffiliateToken(String string) {
                this.zzefr.putString("at", string);
                return this;
            }

            public final Builder setCampaignToken(String string) {
                this.zzefr.putString("ct", string);
                return this;
            }

            public final ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.zzefr, null);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        Bundle zzefr;

        private GoogleAnalyticsParameters(Bundle bundle) {
            this.zzefr = bundle;
        }

        /* synthetic */ GoogleAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzefr = new Bundle();

            public Builder() {
            }

            public Builder(String string, String string2, String string3) {
                this.zzefr.putString("utm_source", string);
                this.zzefr.putString("utm_medium", string2);
                this.zzefr.putString("utm_campaign", string3);
            }

            public final Builder setSource(String string) {
                this.zzefr.putString("utm_source", string);
                return this;
            }

            public final Builder setMedium(String string) {
                this.zzefr.putString("utm_medium", string);
                return this;
            }

            public final Builder setCampaign(String string) {
                this.zzefr.putString("utm_campaign", string);
                return this;
            }

            public final Builder setTerm(String string) {
                this.zzefr.putString("utm_term", string);
                return this;
            }

            public final Builder setContent(String string) {
                this.zzefr.putString("utm_content", string);
                return this;
            }

            public final GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.zzefr, null);
            }
        }
    }

    public static final class IosParameters {
        final Bundle zzefr;

        private IosParameters(Bundle bundle) {
            this.zzefr = bundle;
        }

        /* synthetic */ IosParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzefr = new Bundle();

            public Builder(@NonNull String string) {
                this.zzefr.putString("ibi", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzefr.putParcelable("ifl", (Parcelable)uri);
                return this;
            }

            public final Builder setCustomScheme(String string) {
                this.zzefr.putString("ius", string);
                return this;
            }

            public final Builder setIpadFallbackUrl(Uri uri) {
                this.zzefr.putParcelable("ipfl", (Parcelable)uri);
                return this;
            }

            public final Builder setIpadBundleId(String string) {
                this.zzefr.putString("ipbi", string);
                return this;
            }

            public final Builder setAppStoreId(String string) {
                this.zzefr.putString("isi", string);
                return this;
            }

            public final Builder setMinimumVersion(String string) {
                this.zzefr.putString("imv", string);
                return this;
            }

            public final IosParameters build() {
                return new IosParameters(this.zzefr, null);
            }
        }
    }

    public static final class AndroidParameters {
        final Bundle zzefr;

        private AndroidParameters(Bundle bundle) {
            this.zzefr = bundle;
        }

        /* synthetic */ AndroidParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzefr;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.zzefr = new Bundle();
                this.zzefr.putString("apn", FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String string) {
                this.zzefr = new Bundle();
                this.zzefr.putString("apn", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzefr.putParcelable("afl", (Parcelable)uri);
                return this;
            }

            public final Builder setMinimumVersion(int n) {
                this.zzefr.putInt("amv", n);
                return this;
            }

            public final AndroidParameters build() {
                return new AndroidParameters(this.zzefr, null);
            }
        }
    }

    public static final class Builder {
        private final zzepn zznrx;
        private final Bundle zznrw;
        private final Bundle zznry;

        @Hide
        public Builder(zzepn zzepn2) {
            this.zznrx = zzepn2;
            this.zznrw = new Bundle();
            if (FirebaseApp.getInstance() != null) {
                this.zznrw.putString("apiKey", FirebaseApp.getInstance().getOptions().getApiKey());
            }
            this.zznry = new Bundle();
            this.zznrw.putBundle("parameters", this.zznry);
        }

        public final Builder setLongLink(@NonNull Uri uri) {
            this.zznrw.putParcelable("dynamicLink", (Parcelable)uri);
            return this;
        }

        public final Builder setLink(@NonNull Uri uri) {
            this.zznry.putParcelable("link", (Parcelable)uri);
            return this;
        }

        public final Builder setDynamicLinkDomain(@NonNull String string) {
            this.zznrw.putString("domain", string);
            return this;
        }

        public final Builder setAndroidParameters(AndroidParameters androidParameters) {
            this.zznry.putAll(androidParameters.zzefr);
            return this;
        }

        public final Builder setIosParameters(IosParameters iosParameters) {
            this.zznry.putAll(iosParameters.zzefr);
            return this;
        }

        public final Builder setGoogleAnalyticsParameters(GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.zznry.putAll(googleAnalyticsParameters.zzefr);
            return this;
        }

        public final Builder setItunesConnectAnalyticsParameters(ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.zznry.putAll(itunesConnectAnalyticsParameters.zzefr);
            return this;
        }

        public final Builder setSocialMetaTagParameters(SocialMetaTagParameters socialMetaTagParameters) {
            this.zznry.putAll(socialMetaTagParameters.zzefr);
            return this;
        }

        public final Builder setNavigationInfoParameters(NavigationInfoParameters navigationInfoParameters) {
            this.zznry.putAll(navigationInfoParameters.zzefr);
            return this;
        }

        public final DynamicLink buildDynamicLink() {
            zzepn.zzag(this.zznrw);
            return new DynamicLink(this.zznrw);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink() {
            this.zzcdr();
            return this.zznrx.zzaf(this.zznrw);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink(int n) {
            this.zzcdr();
            this.zznrw.putInt("suffix", n);
            return this.zznrx.zzaf(this.zznrw);
        }

        private final void zzcdr() {
            if (this.zznrw.getString("apiKey") == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

