/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.utilities.NodeSizeEstimator;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.ChildrenNode;
import com.google.firebase.database.snapshot.LeafNode;
import com.google.firebase.database.snapshot.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class CompoundHash {
    private final List<Path> posts;
    private final List<String> hashes;

    private CompoundHash(List<Path> posts, List<String> hashes) {
        if (posts.size() != hashes.size() - 1) {
            throw new IllegalArgumentException("Number of posts need to be n-1 for n hashes in CompoundHash");
        }
        this.posts = posts;
        this.hashes = hashes;
    }

    public List<Path> getPosts() {
        return Collections.unmodifiableList(this.posts);
    }

    public List<String> getHashes() {
        return Collections.unmodifiableList(this.hashes);
    }

    public static CompoundHash fromNode(Node node) {
        return CompoundHash.fromNode(node, new SimpleSizeSplitStrategy(node));
    }

    public static CompoundHash fromNode(Node node, SplitStrategy strategy) {
        if (node.isEmpty()) {
            return new CompoundHash(Collections.emptyList(), Collections.singletonList(""));
        }
        CompoundHashBuilder state = new CompoundHashBuilder(strategy);
        CompoundHash.processNode(node, state);
        state.finishHashing();
        return new CompoundHash(state.currentPaths, state.currentHashes);
    }

    private static void processNode(Node node, final CompoundHashBuilder state) {
        if (node.isLeafNode()) {
            state.processLeaf((LeafNode)node);
        } else {
            if (node.isEmpty()) {
                throw new IllegalArgumentException("Can't calculate hash on empty node!");
            }
            if (!(node instanceof ChildrenNode)) {
                throw new IllegalStateException("Expected children node, but got: " + node);
            }
            ChildrenNode childrenNode = (ChildrenNode)node;
            ChildrenNode.ChildVisitor visitor = new ChildrenNode.ChildVisitor(){

                @Override
                public void visitChild(ChildKey name, Node child) {
                    state.startChild(name);
                    CompoundHash.processNode(child, state);
                    state.endChild();
                }
            };
            childrenNode.forEachChild(visitor, true);
        }
    }

    static class CompoundHashBuilder {
        private StringBuilder optHashValueBuilder = null;
        private Stack<ChildKey> currentPath = new Stack();
        private int lastLeafDepth = -1;
        private int currentPathDepth;
        private boolean needsComma = true;
        private final List<Path> currentPaths = new ArrayList<Path>();
        private final List<String> currentHashes = new ArrayList<String>();
        private final SplitStrategy splitStrategy;

        public CompoundHashBuilder(SplitStrategy strategy) {
            this.splitStrategy = strategy;
        }

        public boolean buildingRange() {
            return this.optHashValueBuilder != null;
        }

        public int currentHashLength() {
            return this.optHashValueBuilder.length();
        }

        public Path currentPath() {
            return this.currentPath(this.currentPathDepth);
        }

        private Path currentPath(int depth) {
            ChildKey[] segments = new ChildKey[depth];
            for (int i = 0; i < depth; ++i) {
                segments[i] = (ChildKey)this.currentPath.get(i);
            }
            return new Path(segments);
        }

        private void ensureRange() {
            if (!this.buildingRange()) {
                this.optHashValueBuilder = new StringBuilder();
                this.optHashValueBuilder.append("(");
                for (ChildKey key : this.currentPath(this.currentPathDepth)) {
                    this.appendKey(this.optHashValueBuilder, key);
                    this.optHashValueBuilder.append(":(");
                }
                this.needsComma = false;
            }
        }

        private void appendKey(StringBuilder builder, ChildKey key) {
            builder.append(Utilities.stringHashV2Representation(key.asString()));
        }

        private void processLeaf(LeafNode<?> node) {
            this.ensureRange();
            this.lastLeafDepth = this.currentPathDepth;
            this.optHashValueBuilder.append(node.getHashRepresentation(Node.HashVersion.V2));
            this.needsComma = true;
            if (this.splitStrategy.shouldSplit(this)) {
                this.endRange();
            }
        }

        private void startChild(ChildKey key) {
            this.ensureRange();
            if (this.needsComma) {
                this.optHashValueBuilder.append(",");
            }
            this.appendKey(this.optHashValueBuilder, key);
            this.optHashValueBuilder.append(":(");
            if (this.currentPathDepth == this.currentPath.size()) {
                this.currentPath.add(key);
            } else {
                this.currentPath.set(this.currentPathDepth, key);
            }
            ++this.currentPathDepth;
            this.needsComma = false;
        }

        private void endChild() {
            --this.currentPathDepth;
            if (this.buildingRange()) {
                this.optHashValueBuilder.append(")");
            }
            this.needsComma = true;
        }

        private void finishHashing() {
            Utilities.hardAssert(this.currentPathDepth == 0, "Can't finish hashing in the middle processing a child");
            if (this.buildingRange()) {
                this.endRange();
            }
            this.currentHashes.add("");
        }

        private void endRange() {
            Utilities.hardAssert(this.buildingRange(), "Can't end range without starting a range!");
            for (int i = 0; i < this.currentPathDepth; ++i) {
                this.optHashValueBuilder.append(")");
            }
            this.optHashValueBuilder.append(")");
            Path lastLeafPath = this.currentPath(this.lastLeafDepth);
            String hash = Utilities.sha1HexDigest(this.optHashValueBuilder.toString());
            this.currentHashes.add(hash);
            this.currentPaths.add(lastLeafPath);
            this.optHashValueBuilder = null;
        }
    }

    private static class SimpleSizeSplitStrategy
    implements SplitStrategy {
        private final long splitThreshold;

        public SimpleSizeSplitStrategy(Node node) {
            long estimatedNodeSize = NodeSizeEstimator.estimateSerializedNodeSize(node);
            this.splitThreshold = Math.max(512L, (long)Math.sqrt(estimatedNodeSize * 100L));
        }

        @Override
        public boolean shouldSplit(CompoundHashBuilder state) {
            return (long)state.currentHashLength() > this.splitThreshold && (state.currentPath().isEmpty() || !state.currentPath().getBack().equals(ChildKey.getPriorityKey()));
        }
    }

    public static interface SplitStrategy {
        public boolean shouldSplit(CompoundHashBuilder var1);
    }
}

