/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.tubesock;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import androidx.annotation.Nullable;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.tubesock.ThreadInitializer;
import com.google.firebase.database.tubesock.WebSocketEventHandler;
import com.google.firebase.database.tubesock.WebSocketException;
import com.google.firebase.database.tubesock.WebSocketHandshake;
import com.google.firebase.database.tubesock.WebSocketReceiver;
import com.google.firebase.database.tubesock.WebSocketWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class WebSocket {
    private static final int SSL_HANDSHAKE_TIMEOUT_MS = 60000;
    private static final String THREAD_BASE_NAME = "TubeSock";
    private static final AtomicInteger clientCount = new AtomicInteger(0);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    static final byte OPCODE_NONE = 0;
    static final byte OPCODE_TEXT = 1;
    static final byte OPCODE_BINARY = 2;
    static final byte OPCODE_CLOSE = 8;
    static final byte OPCODE_PING = 9;
    static final byte OPCODE_PONG = 10;
    private volatile State state = State.NONE;
    private volatile Socket socket = null;
    private WebSocketEventHandler eventHandler = null;
    private final URI url;
    @Nullable
    private final String sslCacheDirectory;
    private final WebSocketReceiver receiver;
    private final WebSocketWriter writer;
    private final WebSocketHandshake handshake;
    private final LogWrapper logger;
    private final int clientId = clientCount.incrementAndGet();
    private final Thread innerThread = WebSocket.getThreadFactory().newThread(new Runnable(){

        @Override
        public void run() {
            WebSocket.this.runReader();
        }
    });
    private static ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private static ThreadInitializer intializer = new ThreadInitializer(){

        @Override
        public void setName(Thread t, String name) {
            t.setName(name);
        }
    };

    static ThreadFactory getThreadFactory() {
        return threadFactory;
    }

    static ThreadInitializer getIntializer() {
        return intializer;
    }

    public static void setThreadFactory(ThreadFactory threadFactory, ThreadInitializer intializer) {
        WebSocket.threadFactory = threadFactory;
        WebSocket.intializer = intializer;
    }

    public WebSocket(ConnectionContext context, URI url) {
        this(context, url, null);
    }

    public WebSocket(ConnectionContext context, URI url, String protocol) {
        this(context, url, protocol, null);
    }

    public WebSocket(ConnectionContext context, URI url, String protocol, Map<String, String> extraHeaders) {
        this.url = url;
        this.sslCacheDirectory = context.getSslCacheDirectory();
        this.logger = new LogWrapper(context.getLogger(), "WebSocket", "sk_" + this.clientId);
        this.handshake = new WebSocketHandshake(url, protocol, extraHeaders);
        this.receiver = new WebSocketReceiver(this);
        this.writer = new WebSocketWriter(this, THREAD_BASE_NAME, this.clientId);
    }

    public void setEventHandler(WebSocketEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    WebSocketEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public synchronized void connect() {
        if (this.state != State.NONE) {
            this.eventHandler.onError(new WebSocketException("connect() already called"));
            this.close();
            return;
        }
        WebSocket.getIntializer().setName(this.getInnerThread(), "TubeSockReader-" + this.clientId);
        this.state = State.CONNECTING;
        this.getInnerThread().start();
    }

    public synchronized void send(String data) {
        this.send((byte)1, data.getBytes(UTF8));
    }

    public synchronized void send(byte[] data) {
        this.send((byte)2, data);
    }

    synchronized void pong(byte[] data) {
        this.send((byte)10, data);
    }

    private synchronized void send(byte opcode, byte[] data) {
        if (this.state != State.CONNECTED) {
            this.eventHandler.onError(new WebSocketException("error while sending data: not connected"));
        } else {
            try {
                this.writer.send(opcode, true, data);
            }
            catch (IOException e) {
                this.eventHandler.onError(new WebSocketException("Failed to send frame", e));
                this.close();
            }
        }
    }

    void handleReceiverError(WebSocketException e) {
        this.eventHandler.onError(e);
        if (this.state == State.CONNECTED) {
            this.close();
        }
        this.closeSocket();
    }

    public synchronized void close() {
        switch (this.state) {
            case NONE: {
                this.state = State.DISCONNECTED;
                return;
            }
            case CONNECTING: {
                this.closeSocket();
                return;
            }
            case CONNECTED: {
                this.sendCloseHandshake();
                return;
            }
            case DISCONNECTING: {
                return;
            }
            case DISCONNECTED: {
                return;
            }
        }
    }

    void onCloseOpReceived() {
        this.closeSocket();
    }

    private synchronized void closeSocket() {
        if (this.state == State.DISCONNECTED) {
            return;
        }
        this.receiver.stopit();
        this.writer.stopIt();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.state = State.DISCONNECTED;
        this.eventHandler.onClose();
    }

    private void sendCloseHandshake() {
        try {
            this.state = State.DISCONNECTING;
            this.writer.stopIt();
            this.writer.send((byte)8, true, new byte[0]);
        }
        catch (IOException e) {
            this.eventHandler.onError(new WebSocketException("Failed to send close frame", e));
        }
    }

    private Socket createSocket() {
        Socket socket;
        String scheme = this.url.getScheme();
        String host = this.url.getHost();
        int port = this.url.getPort();
        if (scheme != null && scheme.equals("ws")) {
            if (port == -1) {
                port = 80;
            }
            try {
                socket = new Socket(host, port);
            }
            catch (UnknownHostException uhe) {
                throw new WebSocketException("unknown host: " + host, uhe);
            }
            catch (IOException ioe) {
                throw new WebSocketException("error while creating socket to " + this.url, ioe);
            }
        }
        if (scheme != null && scheme.equals("wss")) {
            if (port == -1) {
                port = 443;
            }
            SSLSessionCache sessionCache = null;
            try {
                if (this.sslCacheDirectory != null) {
                    sessionCache = new SSLSessionCache(new File(this.sslCacheDirectory));
                }
            }
            catch (IOException e) {
                this.logger.debug("Failed to initialize SSL session cache", e, new Object[0]);
            }
            try {
                SSLSocketFactory factory = SSLCertificateSocketFactory.getDefault((int)60000, sessionCache);
                SSLSocket sslSocket = (SSLSocket)factory.createSocket(host, port);
                HostnameVerifier hv = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sslSession = sslSocket.getSession();
                if (!hv.verify(host, sslSession)) {
                    throw new WebSocketException("Error while verifying secure socket to " + this.url);
                }
                socket = sslSocket;
            }
            catch (UnknownHostException uhe) {
                throw new WebSocketException("unknown host: " + host, uhe);
            }
            catch (IOException ioe) {
                throw new WebSocketException("error while creating secure socket to " + this.url, ioe);
            }
        }
        throw new WebSocketException("unsupported protocol: " + scheme);
        return socket;
    }

    public void blockClose() throws InterruptedException {
        if (this.writer.getInnerThread().getState() != Thread.State.NEW) {
            this.writer.getInnerThread().join();
        }
        this.getInnerThread().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runReader() {
        try {
            Socket socket = this.createSocket();
            WebSocket webSocket = this;
            synchronized (webSocket) {
                this.socket = socket;
                if (this.state == State.DISCONNECTED) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.socket = null;
                    return;
                }
            }
            DataInputStream input = new DataInputStream(socket.getInputStream());
            OutputStream output = socket.getOutputStream();
            output.write(this.handshake.getHandshake());
            boolean handshakeComplete = false;
            int len = 1000;
            byte[] buffer = new byte[len];
            int pos = 0;
            ArrayList<String> handshakeLines = new ArrayList<String>();
            while (!handshakeComplete) {
                String line;
                int b = input.read();
                if (b == -1) {
                    throw new WebSocketException("Connection closed before handshake was complete");
                }
                buffer[pos] = (byte)b;
                if (buffer[++pos - 1] == 10 && buffer[pos - 2] == 13) {
                    line = new String(buffer, UTF8);
                    if (line.trim().equals("")) {
                        handshakeComplete = true;
                    } else {
                        handshakeLines.add(line.trim());
                    }
                    buffer = new byte[len];
                    pos = 0;
                    continue;
                }
                if (pos != 1000) continue;
                line = new String(buffer, UTF8);
                throw new WebSocketException("Unexpected long line in handshake: " + line);
            }
            this.handshake.verifyServerStatusLine((String)handshakeLines.get(0));
            handshakeLines.remove(0);
            HashMap<String, String> lowercaseHeaders = new HashMap<String, String>();
            for (String line : handshakeLines) {
                String[] keyValue = line.split(": ", 2);
                lowercaseHeaders.put(keyValue[0].toLowerCase(Locale.US), keyValue[1].toLowerCase(Locale.US));
            }
            this.handshake.verifyServerHandshakeHeaders(lowercaseHeaders);
            this.writer.setOutput(output);
            this.receiver.setInput(input);
            this.state = State.CONNECTED;
            this.writer.getInnerThread().start();
            this.eventHandler.onOpen();
            this.receiver.run();
            return;
        }
        catch (WebSocketException wse) {
            this.eventHandler.onError(wse);
            return;
        }
        catch (Throwable t) {
            this.eventHandler.onError(new WebSocketException("error while connecting: " + t.getMessage(), t));
            return;
        }
        finally {
            this.close();
        }
    }

    Thread getInnerThread() {
        return this.innerThread;
    }

    private static enum State {
        NONE,
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED;

    }
}

