/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.ValidationPath;
import com.google.firebase.database.core.utilities.Pair;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.utilities.Validation;
import com.google.firebase.database.core.utilities.encoding.CustomClassMapper;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.PriorityUtilities;
import java.util.Map;

@PublicApi
public class OnDisconnect {
    private Repo repo;
    private Path path;

    OnDisconnect(Repo repo, Path path) {
        this.repo = repo;
        this.path = path;
    }

    @NonNull
    @PublicApi
    public Task<Void> setValue(@Nullable Object value) {
        return this.onDisconnectSetInternal(value, PriorityUtilities.NullPriority(), null);
    }

    @NonNull
    @PublicApi
    public Task<Void> setValue(@Nullable Object value, @Nullable String priority) {
        return this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(this.path, priority), null);
    }

    @NonNull
    @PublicApi
    public Task<Void> setValue(@Nullable Object value, double priority) {
        return this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(this.path, priority), null);
    }

    @PublicApi
    public void setValue(@Nullable Object value, @Nullable DatabaseReference.CompletionListener listener) {
        this.onDisconnectSetInternal(value, PriorityUtilities.NullPriority(), listener);
    }

    @PublicApi
    public void setValue(@Nullable Object value, @Nullable String priority, @Nullable DatabaseReference.CompletionListener listener) {
        this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(this.path, priority), listener);
    }

    @PublicApi
    public void setValue(@Nullable Object value, double priority, @Nullable DatabaseReference.CompletionListener listener) {
        this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(this.path, priority), listener);
    }

    @PublicApi
    public void setValue(@Nullable Object value, @Nullable Map priority, @Nullable DatabaseReference.CompletionListener listener) {
        this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(this.path, priority), listener);
    }

    private Task<Void> onDisconnectSetInternal(Object value, Node priority, DatabaseReference.CompletionListener optListener) {
        Validation.validateWritablePath(this.path);
        ValidationPath.validateWithObject(this.path, value);
        Object bouncedValue = CustomClassMapper.convertToPlainJavaTypes(value);
        Validation.validateWritableObject(bouncedValue);
        final Node node = NodeUtilities.NodeFromJSON(bouncedValue, priority);
        final Pair<Task<Void>, DatabaseReference.CompletionListener> wrapped = Utilities.wrapOnComplete(optListener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                OnDisconnect.this.repo.onDisconnectSetValue(OnDisconnect.this.path, node, (DatabaseReference.CompletionListener)wrapped.getSecond());
            }
        });
        return wrapped.getFirst();
    }

    @NonNull
    @PublicApi
    public Task<Void> updateChildren(@NonNull Map<String, Object> update) {
        return this.updateChildrenInternal(update, null);
    }

    @PublicApi
    public void updateChildren(@NonNull Map<String, Object> update, @Nullable DatabaseReference.CompletionListener listener) {
        this.updateChildrenInternal(update, listener);
    }

    private Task<Void> updateChildrenInternal(final Map<String, Object> update, DatabaseReference.CompletionListener optListener) {
        final Map<Path, Node> parsedUpdate = Validation.parseAndValidateUpdate(this.path, update);
        final Pair<Task<Void>, DatabaseReference.CompletionListener> wrapped = Utilities.wrapOnComplete(optListener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                OnDisconnect.this.repo.onDisconnectUpdate(OnDisconnect.this.path, parsedUpdate, (DatabaseReference.CompletionListener)wrapped.getSecond(), update);
            }
        });
        return wrapped.getFirst();
    }

    @NonNull
    @PublicApi
    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    @PublicApi
    public void removeValue(@Nullable DatabaseReference.CompletionListener listener) {
        this.setValue(null, listener);
    }

    @NonNull
    @PublicApi
    public Task<Void> cancel() {
        return this.cancelInternal(null);
    }

    @PublicApi
    public void cancel(@NonNull DatabaseReference.CompletionListener listener) {
        this.cancelInternal(listener);
    }

    private Task<Void> cancelInternal(DatabaseReference.CompletionListener optListener) {
        final Pair<Task<Void>, DatabaseReference.CompletionListener> wrapped = Utilities.wrapOnComplete(optListener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                OnDisconnect.this.repo.onDisconnectCancel(OnDisconnect.this.path, (DatabaseReference.CompletionListener)wrapped.getSecond());
            }
        });
        return wrapped.getFirst();
    }
}

