/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.zzegp;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzegx;
import com.google.android.gms.internal.zzeia;
import com.google.android.gms.internal.zzeib;
import com.google.android.gms.internal.zzepb;
import com.google.android.gms.internal.zzepd;
import com.google.android.gms.internal.zzepf;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<zzeia, FirebaseDatabase>> zzmwp = new HashMap<String, Map<zzeia, FirebaseDatabase>>();
    private final FirebaseApp zzmwq;
    private final zzeia zzmwr;
    private final zzegp zzmws;
    private zzegx zzmwt;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<zzeia, FirebaseDatabase> map = zzmwp.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<zzeia, FirebaseDatabase>();
            zzmwp.put(firebaseApp.getName(), map);
        }
        zzepb zzepb2 = zzepd.zzqj(string);
        if (!zzepb2.zzmxa.isEmpty()) {
            String string2 = zzepb2.zzmxa.toString();
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zzepb2.zzmwr);
        if (firebaseDatabase == null) {
            zzegp zzegp2 = new zzegp();
            if (!firebaseApp.zzbsu()) {
                zzegp2.zzqd(firebaseApp.getName());
            }
            zzegp2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zzepb2.zzmwr, zzegp2);
            map.put(zzepb2.zzmwr, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzeia zzeia2, zzegp zzegp2) {
        this.zzmwq = firebaseApp;
        this.zzmwr = zzeia2;
        this.zzmws = zzegp2;
    }

    public FirebaseApp getApp() {
        return this.zzmwq;
    }

    public DatabaseReference getReference() {
        this.zzbvd();
        return new DatabaseReference(this.zzmwt, zzegu.zzbyn());
    }

    public DatabaseReference getReference(String string) {
        this.zzbvd();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzepf.zzqo(string);
        zzegu zzegu2 = new zzegu(string);
        return new DatabaseReference(this.zzmwt, zzegu2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzbvd();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzepb zzepb2 = zzepd.zzqj(string);
        if (!zzepb2.zzmwr.host.equals(this.zzmwt.zzbyv().host)) {
            String string2 = this.getReference().toString();
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzmwt, zzepb2.zzmxa);
    }

    public void purgeOutstandingWrites() {
        this.zzbvd();
        this.zzmwt.zzp(new zzg(this));
    }

    public void goOnline() {
        this.zzbvd();
        zzeib.zzl(this.zzmwt);
    }

    public void goOffline() {
        this.zzbvd();
        zzeib.zzk(this.zzmwt);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzpn("setLogLevel");
        this.zzmws.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzpn("setPersistenceEnabled");
        this.zzmws.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzpn("setPersistenceCacheSizeBytes");
        this.zzmws.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzpn(String string) {
        if (this.zzmwt != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzbvd() {
        if (this.zzmwt == null) {
            this.zzmwt = zzeib.zza(this.zzmws, this.zzmwr, this);
        }
    }

    static /* synthetic */ zzegx zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzmwt;
    }
}

