/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.app.ApplicationExitInfo;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CrashlyticsAppQualitySessionsSubscriber;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportDataCapture;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportWithSessionId;
import com.google.firebase.crashlytics.internal.common.FirebaseInstallationId;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import com.google.firebase.crashlytics.internal.common.OnDemandCounter;
import com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers;
import com.google.firebase.crashlytics.internal.metadata.LogFileManager;
import com.google.firebase.crashlytics.internal.metadata.UserMetadata;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.send.DataTransportCrashlyticsReportSender;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.Executor;

public class SessionReportingCoordinator {
    private static final String EVENT_TYPE_CRASH = "crash";
    private static final String EVENT_TYPE_LOGGED = "error";
    private static final int EVENT_THREAD_IMPORTANCE = 4;
    private static final int MAX_CHAINED_EXCEPTION_DEPTH = 8;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final CrashlyticsReportDataCapture dataCapture;
    private final CrashlyticsReportPersistence reportPersistence;
    private final DataTransportCrashlyticsReportSender reportsSender;
    private final LogFileManager logFileManager;
    private final UserMetadata reportMetadata;
    private final IdManager idManager;
    private final CrashlyticsWorkers crashlyticsWorkers;

    public static SessionReportingCoordinator create(Context context, IdManager idManager, FileStore fileStore, AppData appData, LogFileManager logFileManager, UserMetadata userMetadata, StackTraceTrimmingStrategy stackTraceTrimmingStrategy, SettingsProvider settingsProvider, OnDemandCounter onDemandCounter, CrashlyticsAppQualitySessionsSubscriber sessionsSubscriber, CrashlyticsWorkers crashlyticsWorkers) {
        CrashlyticsReportDataCapture dataCapture = new CrashlyticsReportDataCapture(context, idManager, appData, stackTraceTrimmingStrategy, settingsProvider);
        CrashlyticsReportPersistence reportPersistence = new CrashlyticsReportPersistence(fileStore, settingsProvider, sessionsSubscriber);
        DataTransportCrashlyticsReportSender reportSender = DataTransportCrashlyticsReportSender.create(context, settingsProvider, onDemandCounter);
        return new SessionReportingCoordinator(dataCapture, reportPersistence, reportSender, logFileManager, userMetadata, idManager, crashlyticsWorkers);
    }

    SessionReportingCoordinator(CrashlyticsReportDataCapture dataCapture, CrashlyticsReportPersistence reportPersistence, DataTransportCrashlyticsReportSender reportsSender, LogFileManager logFileManager, UserMetadata reportMetadata, IdManager idManager, CrashlyticsWorkers crashlyticsWorkers) {
        this.dataCapture = dataCapture;
        this.reportPersistence = reportPersistence;
        this.reportsSender = reportsSender;
        this.logFileManager = logFileManager;
        this.reportMetadata = reportMetadata;
        this.idManager = idManager;
        this.crashlyticsWorkers = crashlyticsWorkers;
    }

    public void onBeginSession(@NonNull String sessionId, long timestampSeconds) {
        CrashlyticsReport capturedReport = this.dataCapture.captureReportData(sessionId, timestampSeconds);
        this.reportPersistence.persistReport(capturedReport);
    }

    public void persistFatalEvent(@NonNull Throwable event, @NonNull Thread thread, @NonNull String sessionId, long timestamp) {
        Logger.getLogger().v("Persisting fatal event for session " + sessionId);
        this.persistEvent(event, thread, sessionId, EVENT_TYPE_CRASH, timestamp, true);
    }

    public void persistNonFatalEvent(@NonNull Throwable event, @NonNull Thread thread, @NonNull String sessionId, long timestamp) {
        Logger.getLogger().v("Persisting non-fatal event for session " + sessionId);
        this.persistEvent(event, thread, sessionId, EVENT_TYPE_LOGGED, timestamp, false);
    }

    @RequiresApi(api=30)
    public void persistRelevantAppExitInfoEvent(String sessionId, List<ApplicationExitInfo> applicationExitInfoList, LogFileManager logFileManagerForSession, UserMetadata userMetadataForSession) {
        ApplicationExitInfo relevantApplicationExitInfo = this.findRelevantApplicationExitInfo(sessionId, applicationExitInfoList);
        if (relevantApplicationExitInfo == null) {
            Logger.getLogger().v("No relevant ApplicationExitInfo occurred during session: " + sessionId);
            return;
        }
        CrashlyticsReport.Session.Event capturedEvent = this.dataCapture.captureAnrEventData(SessionReportingCoordinator.convertApplicationExitInfo(relevantApplicationExitInfo));
        Logger.getLogger().d("Persisting anr for session " + sessionId);
        CrashlyticsReport.Session.Event eventWithLogsAndCustomKeys = this.addLogsAndCustomKeysToEvent(capturedEvent, logFileManagerForSession, userMetadataForSession);
        CrashlyticsReport.Session.Event eventWithRolloutsState = this.addRolloutsStateToEvent(eventWithLogsAndCustomKeys, userMetadataForSession);
        this.reportPersistence.persistEvent(eventWithRolloutsState, sessionId, true);
    }

    public void finalizeSessionWithNativeEvent(@NonNull String sessionId, @NonNull List<NativeSessionFile> nativeSessionFiles, CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        Logger.getLogger().d("SessionReportingCoordinator#finalizeSessionWithNativeEvent");
        ArrayList<CrashlyticsReport.FilesPayload.File> nativeFiles = new ArrayList<CrashlyticsReport.FilesPayload.File>();
        for (NativeSessionFile nativeSessionFile : nativeSessionFiles) {
            CrashlyticsReport.FilesPayload.File filePayload = nativeSessionFile.asFilePayload();
            if (filePayload == null) continue;
            nativeFiles.add(filePayload);
        }
        this.reportPersistence.finalizeSessionWithNativeEvent(sessionId, CrashlyticsReport.FilesPayload.builder().setFiles(Collections.unmodifiableList(nativeFiles)).build(), applicationExitInfo);
    }

    public void finalizeSessions(long timestamp, @Nullable String currentSessionId) {
        this.reportPersistence.finalizeReports(currentSessionId, timestamp);
    }

    public SortedSet<String> listSortedOpenSessionIds() {
        return this.reportPersistence.getOpenSessionIds();
    }

    public boolean hasReportsToSend() {
        return this.reportPersistence.hasFinalizedReports();
    }

    public void removeAllReports() {
        this.reportPersistence.deleteAllReports();
    }

    public Task<Void> sendReports(@NonNull Executor reportSendCompleteExecutor) {
        return this.sendReports(reportSendCompleteExecutor, null);
    }

    public Task<Void> sendReports(@NonNull Executor reportSendCompleteExecutor, @Nullable String sessionId) {
        List<CrashlyticsReportWithSessionId> reportsToSend = this.reportPersistence.loadFinalizedReports();
        ArrayList<Task> sendTasks = new ArrayList<Task>();
        for (CrashlyticsReportWithSessionId reportToSend : reportsToSend) {
            if (sessionId != null && !sessionId.equals(reportToSend.getSessionId())) continue;
            sendTasks.add(this.reportsSender.enqueueReport(this.ensureHasFid(reportToSend), sessionId != null).continueWith(reportSendCompleteExecutor, this::onReportSendComplete));
        }
        return Tasks.whenAll(sendTasks);
    }

    private CrashlyticsReportWithSessionId ensureHasFid(CrashlyticsReportWithSessionId reportToSend) {
        if (reportToSend.getReport().getFirebaseInstallationId() == null || reportToSend.getReport().getFirebaseAuthenticationToken() == null) {
            FirebaseInstallationId firebaseInstallationId = this.idManager.fetchTrueFid(true);
            return CrashlyticsReportWithSessionId.create(reportToSend.getReport().withFirebaseInstallationId(firebaseInstallationId.getFid()).withFirebaseAuthenticationToken(firebaseInstallationId.getAuthToken()), reportToSend.getSessionId(), reportToSend.getReportFile());
        }
        return reportToSend;
    }

    private CrashlyticsReport.Session.Event addMetaDataToEvent(CrashlyticsReport.Session.Event capturedEvent) {
        CrashlyticsReport.Session.Event eventWithLogsAndCustomKeys = this.addLogsAndCustomKeysToEvent(capturedEvent, this.logFileManager, this.reportMetadata);
        CrashlyticsReport.Session.Event eventWithRollouts = this.addRolloutsStateToEvent(eventWithLogsAndCustomKeys, this.reportMetadata);
        return eventWithRollouts;
    }

    private CrashlyticsReport.Session.Event addLogsAndCustomKeysToEvent(CrashlyticsReport.Session.Event capturedEvent) {
        return this.addLogsAndCustomKeysToEvent(capturedEvent, this.logFileManager, this.reportMetadata);
    }

    private CrashlyticsReport.Session.Event addLogsAndCustomKeysToEvent(CrashlyticsReport.Session.Event capturedEvent, LogFileManager logFileManager, UserMetadata reportMetadata) {
        CrashlyticsReport.Session.Event.Builder eventBuilder = capturedEvent.toBuilder();
        String content = logFileManager.getLogString();
        if (content != null) {
            eventBuilder.setLog(CrashlyticsReport.Session.Event.Log.builder().setContent(content).build());
        } else {
            Logger.getLogger().v("No log data to include with this event.");
        }
        List<CrashlyticsReport.CustomAttribute> sortedCustomAttributes = SessionReportingCoordinator.getSortedCustomAttributes(reportMetadata.getCustomKeys());
        List<CrashlyticsReport.CustomAttribute> sortedInternalKeys = SessionReportingCoordinator.getSortedCustomAttributes(reportMetadata.getInternalKeys());
        if (!sortedCustomAttributes.isEmpty() || !sortedInternalKeys.isEmpty()) {
            eventBuilder.setApp(capturedEvent.getApp().toBuilder().setCustomAttributes(sortedCustomAttributes).setInternalKeys(sortedInternalKeys).build());
        }
        return eventBuilder.build();
    }

    private CrashlyticsReport.Session.Event addRolloutsStateToEvent(CrashlyticsReport.Session.Event capturedEvent, UserMetadata reportMetadata) {
        List<CrashlyticsReport.Session.Event.RolloutAssignment> reportRolloutAssignments = reportMetadata.getRolloutsState();
        if (reportRolloutAssignments.isEmpty()) {
            return capturedEvent;
        }
        CrashlyticsReport.Session.Event.Builder eventBuilder = capturedEvent.toBuilder();
        eventBuilder.setRollouts(CrashlyticsReport.Session.Event.RolloutsState.builder().setRolloutAssignments(reportRolloutAssignments).build());
        return eventBuilder.build();
    }

    private void persistEvent(@NonNull Throwable event, @NonNull Thread thread, @NonNull String sessionId, @NonNull String eventType, long timestamp, boolean isFatal) {
        boolean isHighPriority = eventType.equals(EVENT_TYPE_CRASH);
        CrashlyticsReport.Session.Event capturedEvent = this.dataCapture.captureEventData(event, thread, eventType, timestamp, 4, 8, isFatal);
        CrashlyticsReport.Session.Event finallizedEvent = this.addMetaDataToEvent(capturedEvent);
        if (!isFatal) {
            this.crashlyticsWorkers.diskWrite.submit(() -> {
                Logger.getLogger().d("disk worker: log non-fatal event to persistence");
                this.reportPersistence.persistEvent(finallizedEvent, sessionId, isHighPriority);
            });
            return;
        }
        this.reportPersistence.persistEvent(finallizedEvent, sessionId, isHighPriority);
    }

    private boolean onReportSendComplete(@NonNull Task<CrashlyticsReportWithSessionId> task) {
        if (task.isSuccessful()) {
            CrashlyticsReportWithSessionId report = (CrashlyticsReportWithSessionId)task.getResult();
            Logger.getLogger().d("Crashlytics report successfully enqueued to DataTransport: " + report.getSessionId());
            File reportFile = report.getReportFile();
            if (reportFile.delete()) {
                Logger.getLogger().d("Deleted report file: " + reportFile.getPath());
            } else {
                Logger.getLogger().w("Crashlytics could not delete report file: " + reportFile.getPath());
            }
            return true;
        }
        Logger.getLogger().w("Crashlytics report could not be enqueued to DataTransport", task.getException());
        return false;
    }

    @NonNull
    private static List<CrashlyticsReport.CustomAttribute> getSortedCustomAttributes(@NonNull Map<String, String> attributes) {
        ArrayList<CrashlyticsReport.CustomAttribute> attributesList = new ArrayList<CrashlyticsReport.CustomAttribute>();
        attributesList.ensureCapacity(attributes.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributesList.add(CrashlyticsReport.CustomAttribute.builder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        Collections.sort(attributesList, (attr1, attr2) -> attr1.getKey().compareTo(attr2.getKey()));
        return Collections.unmodifiableList(attributesList);
    }

    @RequiresApi(api=30)
    private static CrashlyticsReport.ApplicationExitInfo convertApplicationExitInfo(ApplicationExitInfo applicationExitInfo) {
        String traceFile = null;
        try {
            InputStream traceInputStream = applicationExitInfo.getTraceInputStream();
            if (traceInputStream != null) {
                traceFile = SessionReportingCoordinator.convertInputStreamToString(traceInputStream);
            }
        }
        catch (IOException e) {
            Logger.getLogger().w("Could not get input trace in application exit info: " + applicationExitInfo.toString() + " Error: " + e);
        }
        return CrashlyticsReport.ApplicationExitInfo.builder().setImportance(applicationExitInfo.getImportance()).setProcessName(applicationExitInfo.getProcessName()).setReasonCode(applicationExitInfo.getReason()).setTimestamp(applicationExitInfo.getTimestamp()).setPid(applicationExitInfo.getPid()).setPss(applicationExitInfo.getPss()).setRss(applicationExitInfo.getRss()).setTraceFile(traceFile).build();
    }

    @VisibleForTesting
    @RequiresApi(api=19)
    public static String convertInputStreamToString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] bytes = new byte[8192];
        while ((length = inputStream.read(bytes)) != -1) {
            byteArrayOutputStream.write(bytes, 0, length);
        }
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
    }

    @RequiresApi(api=30)
    @Nullable
    private ApplicationExitInfo findRelevantApplicationExitInfo(String sessionId, List<ApplicationExitInfo> applicationExitInfoList) {
        long sessionStartTime = this.reportPersistence.getStartTimestampMillis(sessionId);
        for (ApplicationExitInfo applicationExitInfo : applicationExitInfoList) {
            if (applicationExitInfo.getTimestamp() < sessionStartTime) {
                return null;
            }
            if (applicationExitInfo.getReason() != 6) continue;
            return applicationExitInfo;
        }
        return null;
    }
}

