/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.annotation.SuppressLint;
import android.os.Looper;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.firebase.crashlytics.internal.common.ExecutorUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Utils {
    private static final int TIMEOUT_SEC = 4;
    private static final ExecutorService TASK_CONTINUATION_EXECUTOR_SERVICE = ExecutorUtils.buildSingleThreadExecutorService("awaitEvenIfOnMainThread task continuation executor");

    @SuppressLint(value={"TaskMainThread"})
    public static <T> Task<T> race(Task<T> t1, Task<T> t2) {
        TaskCompletionSource result = new TaskCompletionSource();
        Continuation continuation = task -> {
            if (task.isSuccessful()) {
                result.trySetResult(task.getResult());
            } else if (task.getException() != null) {
                result.trySetException(task.getException());
            }
            return null;
        };
        t1.continueWith(continuation);
        t2.continueWith(continuation);
        return result.getTask();
    }

    public static <T> Task<T> race(Executor executor, Task<T> t1, Task<T> t2) {
        TaskCompletionSource result = new TaskCompletionSource();
        Continuation continuation = task -> {
            if (task.isSuccessful()) {
                result.trySetResult(task.getResult());
            } else if (task.getException() != null) {
                result.trySetException(task.getException());
            }
            return null;
        };
        t1.continueWith(executor, continuation);
        t2.continueWith(executor, continuation);
        return result.getTask();
    }

    public static <T> Task<T> callTask(Executor executor, Callable<Task<T>> callable) {
        TaskCompletionSource result = new TaskCompletionSource();
        executor.execute(() -> {
            try {
                ((Task)callable.call()).continueWith(executor, task -> {
                    if (task.isSuccessful()) {
                        result.setResult(task.getResult());
                    } else if (task.getException() != null) {
                        result.setException(task.getException());
                    }
                    return null;
                });
            }
            catch (Exception e) {
                result.setException(e);
            }
        });
        return result.getTask();
    }

    public static <T> T awaitEvenIfOnMainThread(Task<T> task) throws InterruptedException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        task.continueWith((Executor)TASK_CONTINUATION_EXECUTOR_SERVICE, unusedTask -> {
            latch.countDown();
            return null;
        });
        if (Looper.getMainLooper() == Looper.myLooper()) {
            latch.await(3L, TimeUnit.SECONDS);
        } else {
            latch.await(4L, TimeUnit.SECONDS);
        }
        if (task.isSuccessful()) {
            return (T)task.getResult();
        }
        if (task.isCanceled()) {
            throw new CancellationException("Task is already canceled");
        }
        if (task.isComplete()) {
            throw new IllegalStateException(task.getException());
        }
        throw new TimeoutException();
    }

    @CanIgnoreReturnValue
    public static boolean awaitUninterruptibly(CountDownLatch latch, long timeout, TimeUnit unit) {
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    boolean bl = latch.await(remainingNanos, TimeUnit.NANOSECONDS);
                    return bl;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Utils() {
    }
}

