/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.analytics;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventReceiver;
import com.google.firebase.crashlytics.internal.analytics.CrashlyticsOriginAnalyticsEventLogger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BlockingAnalyticsEventLogger
implements AnalyticsEventReceiver,
AnalyticsEventLogger {
    static final String APP_EXCEPTION_EVENT_NAME = "_ae";
    private final CrashlyticsOriginAnalyticsEventLogger baseAnalyticsEventLogger;
    private final int timeout;
    private final TimeUnit timeUnit;
    private final Object latchLock = new Object();
    private CountDownLatch eventLatch;
    private boolean callbackReceived = false;

    public BlockingAnalyticsEventLogger(@NonNull CrashlyticsOriginAnalyticsEventLogger baseAnalyticsEventLogger, int timeout, TimeUnit timeUnit) {
        this.baseAnalyticsEventLogger = baseAnalyticsEventLogger;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logEvent(@NonNull String name, @Nullable Bundle params) {
        Object object = this.latchLock;
        synchronized (object) {
            Logger.getLogger().v("Logging event " + name + " to Firebase Analytics with params " + params);
            this.eventLatch = new CountDownLatch(1);
            this.callbackReceived = false;
            this.baseAnalyticsEventLogger.logEvent(name, params);
            Logger.getLogger().v("Awaiting app exception callback from Analytics...");
            try {
                if (this.eventLatch.await(this.timeout, this.timeUnit)) {
                    this.callbackReceived = true;
                    Logger.getLogger().v("App exception callback received from Analytics listener.");
                } else {
                    Logger.getLogger().w("Timeout exceeded while awaiting app exception callback from Analytics listener.");
                }
            }
            catch (InterruptedException ie) {
                Logger.getLogger().e("Interrupted while awaiting app exception callback from Analytics listener.");
            }
            this.eventLatch = null;
        }
    }

    @Override
    public void onEvent(@NonNull String name, @NonNull Bundle params) {
        CountDownLatch eventLatch = this.eventLatch;
        if (eventLatch == null) {
            return;
        }
        if (APP_EXCEPTION_EVENT_NAME.equals(name)) {
            eventLatch.countDown();
        }
    }

    boolean isCallbackReceived() {
        return this.callbackReceived;
    }
}

