/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.inject.Deferred;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import java.util.Arrays;
import java.util.List;

public class CrashlyticsRegistrar
implements ComponentRegistrar {
    public List<Component<?>> getComponents() {
        return Arrays.asList(Component.builder(FirebaseCrashlytics.class).add(Dependency.required(FirebaseApp.class)).add(Dependency.required(FirebaseInstallationsApi.class)).add(Dependency.deferred(CrashlyticsNativeComponent.class)).add(Dependency.deferred(AnalyticsConnector.class)).factory(this::buildCrashlytics).eagerInDefaultApp().build(), LibraryVersionComponent.create((String)"fire-cls", (String)"18.2.8"));
    }

    private FirebaseCrashlytics buildCrashlytics(ComponentContainer container) {
        FirebaseApp app = (FirebaseApp)container.get(FirebaseApp.class);
        Deferred nativeComponent = container.getDeferred(CrashlyticsNativeComponent.class);
        Deferred analyticsConnector = container.getDeferred(AnalyticsConnector.class);
        FirebaseInstallationsApi firebaseInstallations = (FirebaseInstallationsApi)container.get(FirebaseInstallationsApi.class);
        return FirebaseCrashlytics.init(app, firebaseInstallations, (Deferred<CrashlyticsNativeComponent>)nativeComponent, (Deferred<AnalyticsConnector>)analyticsConnector);
    }
}

