/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;

class NativeSessionFileGzipper {
    NativeSessionFileGzipper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processNativeSessions(File nativeSessionDirectory, List<NativeSessionFile> streams) {
        for (NativeSessionFile stream : streams) {
            InputStream inputStream = null;
            try {
                inputStream = stream.getStream();
                if (inputStream == null) continue;
                NativeSessionFileGzipper.gzipInputStream(inputStream, new File(nativeSessionDirectory, stream.getReportsEndpointFilename()));
            }
            catch (IOException iOException) {}
            continue;
            finally {
                CommonUtils.closeQuietly(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gzipInputStream(@Nullable InputStream input, @NonNull File output) throws IOException {
        if (input == null) {
            return;
        }
        byte[] buffer = new byte[8192];
        GZIPOutputStream gos = null;
        try {
            int read;
            gos = new GZIPOutputStream(new FileOutputStream(output));
            while ((read = input.read(buffer)) > 0) {
                gos.write(buffer, 0, read);
            }
            gos.finish();
        }
        catch (Throwable throwable) {
            CommonUtils.closeQuietly(gos);
            throw throwable;
        }
        CommonUtils.closeQuietly(gos);
    }
}

