/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;

final class AutoValue_CrashlyticsReport_Session_OperatingSystem
extends CrashlyticsReport.Session.OperatingSystem {
    private final int platform;
    private final String version;
    private final String buildVersion;
    private final boolean jailbroken;

    private AutoValue_CrashlyticsReport_Session_OperatingSystem(int platform, String version, String buildVersion, boolean jailbroken) {
        this.platform = platform;
        this.version = version;
        this.buildVersion = buildVersion;
        this.jailbroken = jailbroken;
    }

    @Override
    public int getPlatform() {
        return this.platform;
    }

    @Override
    @NonNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NonNull
    public String getBuildVersion() {
        return this.buildVersion;
    }

    @Override
    public boolean isJailbroken() {
        return this.jailbroken;
    }

    public String toString() {
        return "OperatingSystem{platform=" + this.platform + ", version=" + this.version + ", buildVersion=" + this.buildVersion + ", jailbroken=" + this.jailbroken + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CrashlyticsReport.Session.OperatingSystem) {
            CrashlyticsReport.Session.OperatingSystem that = (CrashlyticsReport.Session.OperatingSystem)o;
            return this.platform == that.getPlatform() && this.version.equals(that.getVersion()) && this.buildVersion.equals(that.getBuildVersion()) && this.jailbroken == that.isJailbroken();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.platform;
        h$ *= 1000003;
        h$ ^= this.version.hashCode();
        h$ *= 1000003;
        h$ ^= this.buildVersion.hashCode();
        h$ *= 1000003;
        return h$ ^= this.jailbroken ? 1231 : 1237;
    }

    static final class Builder
    extends CrashlyticsReport.Session.OperatingSystem.Builder {
        private Integer platform;
        private String version;
        private String buildVersion;
        private Boolean jailbroken;

        Builder() {
        }

        @Override
        public CrashlyticsReport.Session.OperatingSystem.Builder setPlatform(int platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.OperatingSystem.Builder setVersion(String version) {
            if (version == null) {
                throw new NullPointerException("Null version");
            }
            this.version = version;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.OperatingSystem.Builder setBuildVersion(String buildVersion) {
            if (buildVersion == null) {
                throw new NullPointerException("Null buildVersion");
            }
            this.buildVersion = buildVersion;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.OperatingSystem.Builder setJailbroken(boolean jailbroken) {
            this.jailbroken = jailbroken;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.OperatingSystem build() {
            String missing = "";
            if (this.platform == null) {
                missing = missing + " platform";
            }
            if (this.version == null) {
                missing = missing + " version";
            }
            if (this.buildVersion == null) {
                missing = missing + " buildVersion";
            }
            if (this.jailbroken == null) {
                missing = missing + " jailbroken";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CrashlyticsReport_Session_OperatingSystem(this.platform, this.version, this.buildVersion, this.jailbroken);
        }
    }
}

