/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Debug;
import android.os.StatFs;
import android.provider.Settings;
import android.text.TextUtils;
import com.google.firebase.crashlytics.internal.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;

public class CommonUtils {
    private static final String SHA1_INSTANCE = "SHA-1";
    private static final String GOLDFISH = "goldfish";
    private static final String RANCHU = "ranchu";
    private static final String SDK = "sdk";
    public static final String SHARED_PREFS_NAME = "com.google.firebase.crashlytics";
    public static final String LEGACY_SHARED_PREFS_NAME = "com.crashlytics.prefs";
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final String MAPPING_FILE_ID_RESOURCE_NAME = "com.google.firebase.crashlytics.mapping_file_id";
    static final String LEGACY_MAPPING_FILE_ID_RESOURCE_NAME = "com.crashlytics.android.build_id";
    private static final long UNCALCULATED_TOTAL_RAM = -1L;
    static final int BYTES_IN_A_GIGABYTE = 0x40000000;
    static final int BYTES_IN_A_MEGABYTE = 0x100000;
    static final int BYTES_IN_A_KILOBYTE = 1024;
    private static long totalRamInBytes = -1L;
    public static final int DEVICE_STATE_ISSIMULATOR = 1;
    public static final int DEVICE_STATE_JAILBROKEN = 2;
    public static final int DEVICE_STATE_DEBUGGERATTACHED = 4;
    public static final int DEVICE_STATE_BETAOS = 8;
    public static final int DEVICE_STATE_VENDORINTERNAL = 16;
    public static final int DEVICE_STATE_COMPROMISEDLIBRARIES = 32;

    public static SharedPreferences getSharedPrefs(Context context) {
        return context.getSharedPreferences(SHARED_PREFS_NAME, 0);
    }

    public static SharedPreferences getLegacySharedPrefs(Context context) {
        return context.getSharedPreferences(LEGACY_SHARED_PREFS_NAME, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractFieldFromSystemFile(File file, String fieldname) {
        String toReturn = null;
        if (file.exists()) {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(file), 1024);
                while ((line = br.readLine()) != null) {
                    Pattern pattern = Pattern.compile("\\s*:\\s*");
                    String[] pieces = pattern.split(line, 2);
                    if (pieces.length <= 1 || !pieces[0].equals(fieldname)) continue;
                    toReturn = pieces[1];
                    break;
                }
            }
            catch (Exception e) {
                try {
                    Logger.getLogger().e("Error parsing " + file, e);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeOrLog(br, "Failed to close system file reader.");
                    throw throwable;
                }
                CommonUtils.closeOrLog(br, "Failed to close system file reader.");
            }
            CommonUtils.closeOrLog(br, "Failed to close system file reader.");
        }
        return toReturn;
    }

    public static int getCpuArchitectureInt() {
        return Architecture.getValue().ordinal();
    }

    public static synchronized long getTotalRamInBytes() {
        if (totalRamInBytes == -1L) {
            long bytes = 0L;
            String result = CommonUtils.extractFieldFromSystemFile(new File("/proc/meminfo"), "MemTotal");
            if (!TextUtils.isEmpty((CharSequence)result)) {
                result = result.toUpperCase(Locale.US);
                try {
                    if (result.endsWith("KB")) {
                        bytes = CommonUtils.convertMemInfoToBytes(result, "KB", 1024);
                    } else if (result.endsWith("MB")) {
                        bytes = CommonUtils.convertMemInfoToBytes(result, "MB", 0x100000);
                    } else if (result.endsWith("GB")) {
                        bytes = CommonUtils.convertMemInfoToBytes(result, "GB", 0x40000000);
                    } else {
                        Logger.getLogger().w("Unexpected meminfo format while computing RAM: " + result);
                    }
                }
                catch (NumberFormatException e) {
                    Logger.getLogger().e("Unexpected meminfo format while computing RAM: " + result, e);
                }
            }
            totalRamInBytes = bytes;
        }
        return totalRamInBytes;
    }

    static long convertMemInfoToBytes(String memInfo, String notation, int notationMultiplier) {
        return Long.parseLong(memInfo.split(notation)[0].trim()) * (long)notationMultiplier;
    }

    public static ActivityManager.RunningAppProcessInfo getAppProcessInfo(String packageName, Context context) {
        ActivityManager actman = (ActivityManager)context.getSystemService("activity");
        List processes = actman.getRunningAppProcesses();
        ActivityManager.RunningAppProcessInfo procInfo = null;
        if (processes != null) {
            for (ActivityManager.RunningAppProcessInfo info : processes) {
                if (!info.processName.equals(packageName)) continue;
                procInfo = info;
                break;
            }
        }
        return procInfo;
    }

    public static String streamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static String sha1(String source) {
        return CommonUtils.hash(source, SHA1_INSTANCE);
    }

    private static String hash(String s, String algorithm) {
        return CommonUtils.hash(s.getBytes(), algorithm);
    }

    private static String hash(byte[] bytes, String algorithm) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.getLogger().e("Could not create hashing algorithm: " + algorithm + ", returning empty string.", e);
            return "";
        }
        digest.update(bytes);
        return CommonUtils.hexify(digest.digest());
    }

    public static String createInstanceIdFrom(String ... sliceIds) {
        if (sliceIds == null || sliceIds.length == 0) {
            return null;
        }
        ArrayList<String> sliceIdList = new ArrayList<String>();
        for (String id : sliceIds) {
            if (id == null) continue;
            sliceIdList.add(id.replace("-", "").toLowerCase(Locale.US));
        }
        Collections.sort(sliceIdList);
        StringBuilder sb = new StringBuilder();
        for (String id : sliceIdList) {
            sb.append(id);
        }
        String concatValue = sb.toString();
        return concatValue.length() > 0 ? CommonUtils.sha1(concatValue) : null;
    }

    public static long calculateFreeRamInBytes(Context context) {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(mi);
        return mi.availMem;
    }

    public static long calculateUsedDiskSpaceInBytes(String path) {
        StatFs statFs = new StatFs(path);
        long blockSizeBytes = statFs.getBlockSize();
        long totalSpaceBytes = blockSizeBytes * (long)statFs.getBlockCount();
        long availableSpaceBytes = blockSizeBytes * (long)statFs.getAvailableBlocks();
        return totalSpaceBytes - availableSpaceBytes;
    }

    public static boolean getProximitySensorEnabled(Context context) {
        if (CommonUtils.isEmulator(context)) {
            return false;
        }
        SensorManager sm = (SensorManager)context.getSystemService("sensor");
        Sensor prox = sm.getDefaultSensor(8);
        return prox != null;
    }

    @Deprecated
    public static boolean isLoggingEnabled(Context context) {
        return false;
    }

    public static boolean getBooleanResourceValue(Context context, String key, boolean defaultValue) {
        Resources resources;
        if (context != null && (resources = context.getResources()) != null) {
            int id = CommonUtils.getResourcesIdentifier(context, key, "bool");
            if (id > 0) {
                return resources.getBoolean(id);
            }
            id = CommonUtils.getResourcesIdentifier(context, key, "string");
            if (id > 0) {
                return Boolean.parseBoolean(context.getString(id));
            }
        }
        return defaultValue;
    }

    public static int getResourcesIdentifier(Context context, String key, String resourceType) {
        Resources resources = context.getResources();
        return resources.getIdentifier(key, resourceType, CommonUtils.getResourcePackageName(context));
    }

    public static boolean isEmulator(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return Build.PRODUCT.contains(SDK) || Build.HARDWARE.contains(GOLDFISH) || Build.HARDWARE.contains(RANCHU) || androidId == null;
    }

    public static boolean isRooted(Context context) {
        boolean isEmulator = CommonUtils.isEmulator(context);
        String buildTags = Build.TAGS;
        if (!isEmulator && buildTags != null && buildTags.contains("test-keys")) {
            return true;
        }
        File file = new File("/system/app/Superuser.apk");
        if (file.exists()) {
            return true;
        }
        file = new File("/system/xbin/su");
        return !isEmulator && file.exists();
    }

    public static boolean isDebuggerAttached() {
        return Debug.isDebuggerConnected() || Debug.waitingForDebugger();
    }

    public static int getDeviceState(Context context) {
        int deviceState = 0;
        if (CommonUtils.isEmulator(context)) {
            deviceState |= 1;
        }
        if (CommonUtils.isRooted(context)) {
            deviceState |= 2;
        }
        if (CommonUtils.isDebuggerAttached()) {
            deviceState |= 4;
        }
        return deviceState;
    }

    public static String hexify(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_VALUES[v >>> 4];
            hexChars[i * 2 + 1] = HEX_VALUES[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean isAppDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    public static String getStringsFileValue(Context context, String key) {
        int id = CommonUtils.getResourcesIdentifier(context, key, "string");
        if (id > 0) {
            return context.getString(id);
        }
        return "";
    }

    public static void closeOrLog(Closeable c, String message) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                Logger.getLogger().e(message, e);
            }
        }
    }

    public static String padWithZerosToMaxIntWidth(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be zero or greater");
        }
        return String.format(Locale.US, "%1$10s", value).replace(' ', '0');
    }

    public static String getResourcePackageName(Context context) {
        String resourcePackageName;
        int iconId = context.getApplicationContext().getApplicationInfo().icon;
        if (iconId > 0) {
            try {
                resourcePackageName = context.getResources().getResourcePackageName(iconId);
                if ("android".equals(resourcePackageName)) {
                    resourcePackageName = context.getPackageName();
                }
            }
            catch (Resources.NotFoundException e) {
                resourcePackageName = context.getPackageName();
            }
        } else {
            resourcePackageName = context.getPackageName();
        }
        return resourcePackageName;
    }

    public static String getMappingFileId(Context context) {
        String mappingFileId = null;
        int id = CommonUtils.getResourcesIdentifier(context, MAPPING_FILE_ID_RESOURCE_NAME, "string");
        if (id == 0) {
            id = CommonUtils.getResourcesIdentifier(context, LEGACY_MAPPING_FILE_ID_RESOURCE_NAME, "string");
        }
        if (id != 0) {
            mappingFileId = context.getResources().getString(id);
        }
        return mappingFileId;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean checkPermission(Context context, String permission2) {
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean canTryConnection(Context context) {
        if (CommonUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
        return true;
    }

    static enum Architecture {
        X86_32,
        X86_64,
        ARM_UNKNOWN,
        PPC,
        PPC64,
        ARMV6,
        ARMV7,
        UNKNOWN,
        ARMV7S,
        ARM64;

        private static final Map<String, Architecture> matcher;

        static Architecture getValue() {
            String arch = Build.CPU_ABI;
            if (TextUtils.isEmpty((CharSequence)arch)) {
                Logger.getLogger().v("Architecture#getValue()::Build.CPU_ABI returned null or empty");
                return UNKNOWN;
            }
            Architecture value = matcher.get(arch = arch.toLowerCase(Locale.US));
            if (value == null) {
                value = UNKNOWN;
            }
            return value;
        }

        static {
            matcher = new HashMap<String, Architecture>(4);
            matcher.put("armeabi-v7a", ARMV7);
            matcher.put("armeabi", ARMV6);
            matcher.put("arm64-v8a", ARM64);
            matcher.put("x86", X86_32);
        }
    }
}

