/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.settings.model.AppSettingsData;

public enum DataTransportState {
    NONE,
    JAVA_ONLY,
    ALL;

    static final int REPORT_UPLOAD_VARIANT_LEGACY = 1;
    static final int REPORT_UPLOAD_VARIANT_DATATRANSPORT = 2;

    @NonNull
    static DataTransportState getState(boolean dataTransportState, boolean dataTransportNativeState) {
        if (!dataTransportState) {
            return NONE;
        }
        if (!dataTransportNativeState) {
            return JAVA_ONLY;
        }
        return ALL;
    }

    @NonNull
    static DataTransportState getState(@NonNull AppSettingsData appSettingsData) {
        boolean dataTransportState = appSettingsData.reportUploadVariant == 2;
        boolean dataTransportNativeState = appSettingsData.nativeReportUploadVariant == 2;
        return DataTransportState.getState(dataTransportState, dataTransportNativeState);
    }
}

