/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings.network;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AbstractSpiCall;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.network.HttpMethod;
import com.google.firebase.crashlytics.internal.network.HttpRequest;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.network.HttpResponse;
import com.google.firebase.crashlytics.internal.settings.model.SettingsRequest;
import com.google.firebase.crashlytics.internal.settings.network.SettingsSpiCall;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class DefaultSettingsSpiCall
extends AbstractSpiCall
implements SettingsSpiCall {
    static final String BUILD_VERSION_PARAM = "build_version";
    static final String DISPLAY_VERSION_PARAM = "display_version";
    static final String INSTANCE_PARAM = "instance";
    static final String SOURCE_PARAM = "source";
    static final String HEADER_DEVICE_MODEL = "X-CRASHLYTICS-DEVICE-MODEL";
    static final String HEADER_OS_BUILD_VERSION = "X-CRASHLYTICS-OS-BUILD-VERSION";
    static final String HEADER_OS_DISPLAY_VERSION = "X-CRASHLYTICS-OS-DISPLAY-VERSION";
    static final String HEADER_INSTALLATION_ID = "X-CRASHLYTICS-INSTALLATION-ID";
    private Logger logger;

    public DefaultSettingsSpiCall(String protocolAndHostOverride, String url, HttpRequestFactory requestFactory) {
        this(protocolAndHostOverride, url, requestFactory, HttpMethod.GET, Logger.getLogger());
    }

    DefaultSettingsSpiCall(String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, HttpMethod method, Logger logger) {
        super(protocolAndHostOverride, url, requestFactory, method);
        this.logger = logger;
    }

    @Override
    public JSONObject invoke(SettingsRequest requestData, boolean dataCollectionToken) {
        if (!dataCollectionToken) {
            throw new RuntimeException("An invalid data collection token was used.");
        }
        JSONObject toReturn = null;
        try {
            Map<String, String> queryParams = this.getQueryParamsFor(requestData);
            HttpRequest httpRequest = this.getHttpRequest(queryParams);
            httpRequest = this.applyHeadersTo(httpRequest, requestData);
            this.logger.d("Requesting settings from " + this.getUrl());
            this.logger.d("Settings query params were: " + queryParams);
            HttpResponse httpResponse = httpRequest.execute();
            this.logger.d("Settings request ID: " + httpResponse.header("X-REQUEST-ID"));
            toReturn = this.handleResponse(httpResponse);
        }
        catch (IOException e) {
            this.logger.e("Settings request failed.", e);
            toReturn = null;
        }
        return toReturn;
    }

    JSONObject handleResponse(HttpResponse httpResponse) {
        JSONObject toReturn;
        int statusCode = httpResponse.code();
        this.logger.d("Settings result was: " + statusCode);
        if (this.requestWasSuccessful(statusCode)) {
            toReturn = this.getJsonObjectFrom(httpResponse.body());
        } else {
            this.logger.e("Failed to retrieve settings from " + this.getUrl());
            toReturn = null;
        }
        return toReturn;
    }

    boolean requestWasSuccessful(int httpStatusCode) {
        return httpStatusCode == 200 || httpStatusCode == 201 || httpStatusCode == 202 || httpStatusCode == 203;
    }

    private JSONObject getJsonObjectFrom(String httpRequestBody) {
        try {
            return new JSONObject(httpRequestBody);
        }
        catch (Exception e) {
            this.logger.d("Failed to parse settings JSON from " + this.getUrl(), e);
            this.logger.d("Settings response " + httpRequestBody);
            return null;
        }
    }

    private Map<String, String> getQueryParamsFor(SettingsRequest requestData) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(BUILD_VERSION_PARAM, requestData.buildVersion);
        queryParams.put(DISPLAY_VERSION_PARAM, requestData.displayVersion);
        queryParams.put(SOURCE_PARAM, Integer.toString(requestData.source));
        String instanceId = requestData.instanceId;
        if (!CommonUtils.isNullOrEmpty(instanceId)) {
            queryParams.put(INSTANCE_PARAM, instanceId);
        }
        return queryParams;
    }

    private HttpRequest applyHeadersTo(HttpRequest request, SettingsRequest requestData) {
        this.applyNonNullHeader(request, "X-CRASHLYTICS-GOOGLE-APP-ID", requestData.googleAppId);
        this.applyNonNullHeader(request, "X-CRASHLYTICS-API-CLIENT-TYPE", "android");
        this.applyNonNullHeader(request, "X-CRASHLYTICS-API-CLIENT-VERSION", CrashlyticsCore.getVersion());
        this.applyNonNullHeader(request, "Accept", "application/json");
        this.applyNonNullHeader(request, HEADER_DEVICE_MODEL, requestData.deviceModel);
        this.applyNonNullHeader(request, HEADER_OS_BUILD_VERSION, requestData.osBuildVersion);
        this.applyNonNullHeader(request, HEADER_OS_DISPLAY_VERSION, requestData.osDisplayVersion);
        this.applyNonNullHeader(request, HEADER_INSTALLATION_ID, requestData.installIdProvider.getCrashlyticsInstallId());
        return request;
    }

    private void applyNonNullHeader(HttpRequest request, String key, String value) {
        if (value != null) {
            request.header(key, value);
        }
    }
}

