/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.ndk;

import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.ndk.BinaryImagesConverter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

class Sha1FileIdStrategy
implements BinaryImagesConverter.FileIdStrategy {
    Sha1FileIdStrategy() {
    }

    @Override
    public String createId(File file) throws IOException {
        return Sha1FileIdStrategy.getFileSHA(file.getPath());
    }

    private static String getFileSHA(String path) throws IOException {
        String sha = null;
        BufferedInputStream data = null;
        try {
            data = new BufferedInputStream(new FileInputStream(path));
            sha = CommonUtils.sha1(data);
        }
        catch (Throwable throwable) {
            CommonUtils.closeQuietly(data);
            throw throwable;
        }
        CommonUtils.closeQuietly(data);
        return sha;
    }
}

