/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.log;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.log.FileLogStore;
import com.google.firebase.crashlytics.internal.log.QueueFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Locale;

class QueueFileLogStore
implements FileLogStore {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File workingFile;
    private final int maxLogSize;
    private QueueFile logFile;

    QueueFileLogStore(File workingFile, int maxLogSize) {
        this.workingFile = workingFile;
        this.maxLogSize = maxLogSize;
    }

    @Override
    public void writeToLog(long timestamp, String msg) {
        this.openLogFile();
        this.doWriteToLog(timestamp, msg);
    }

    @Override
    public byte[] getLogAsBytes() {
        LogBytes logBytes = this.getLogBytes();
        if (logBytes == null) {
            return null;
        }
        byte[] rawBytes = new byte[logBytes.offset];
        System.arraycopy(logBytes.bytes, 0, rawBytes, 0, logBytes.offset);
        return rawBytes;
    }

    @Override
    public String getLogAsString() {
        byte[] logBytes = this.getLogAsBytes();
        return logBytes != null ? new String(logBytes, UTF_8) : null;
    }

    private LogBytes getLogBytes() {
        if (!this.workingFile.exists()) {
            return null;
        }
        this.openLogFile();
        if (this.logFile == null) {
            return null;
        }
        final int[] offsetHolder = new int[]{0};
        final byte[] logBytes = new byte[this.logFile.usedBytes()];
        try {
            this.logFile.forEach(new QueueFile.ElementReader(){

                @Override
                public void read(InputStream in, int length) throws IOException {
                    try {
                        in.read(logBytes, offsetHolder[0], length);
                        offsetHolder[0] = offsetHolder[0] + length;
                    }
                    finally {
                        in.close();
                    }
                }
            });
        }
        catch (IOException e) {
            Logger.getLogger().e("A problem occurred while reading the Crashlytics log file.", e);
        }
        return new LogBytes(logBytes, offsetHolder[0]);
    }

    @Override
    public void closeLogFile() {
        CommonUtils.closeOrLog(this.logFile, "There was a problem closing the Crashlytics log file.");
        this.logFile = null;
    }

    @Override
    public void deleteLogFile() {
        this.closeLogFile();
        this.workingFile.delete();
    }

    private void openLogFile() {
        if (this.logFile == null) {
            try {
                this.logFile = new QueueFile(this.workingFile);
            }
            catch (IOException e) {
                Logger.getLogger().e("Could not open log file: " + this.workingFile, e);
            }
        }
    }

    private void doWriteToLog(long timestamp, String msg) {
        if (this.logFile == null) {
            return;
        }
        if (msg == null) {
            msg = "null";
        }
        try {
            int quarterMaxLogSize = this.maxLogSize / 4;
            if (msg.length() > quarterMaxLogSize) {
                msg = "..." + msg.substring(msg.length() - quarterMaxLogSize);
            }
            msg = msg.replaceAll("\r", " ");
            msg = msg.replaceAll("\n", " ");
            byte[] msgBytes = String.format(Locale.US, "%d %s%n", timestamp, msg).getBytes(UTF_8);
            this.logFile.add(msgBytes);
            while (!this.logFile.isEmpty() && this.logFile.usedBytes() > this.maxLogSize) {
                this.logFile.remove();
            }
        }
        catch (IOException e) {
            Logger.getLogger().e("There was a problem writing to the Crashlytics log.", e);
        }
    }

    private class LogBytes {
        public final byte[] bytes;
        public final int offset;

        LogBytes(byte[] bytes, int offset) {
            this.bytes = bytes;
            this.offset = offset;
        }
    }
}

