/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.ndk;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.ndk.BinaryImagesConverter;
import com.google.firebase.crashlytics.internal.ndk.Sha1FileIdStrategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public final class NativeFileUtils {
    private NativeFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static byte[] binaryImagesJsonFromMapsFile(@Nullable File file, @NonNull Context context) throws IOException {
        byte[] byArray;
        if (file == null || !file.exists()) {
            return new byte[0];
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            byArray = new BinaryImagesConverter(context, new Sha1FileIdStrategy()).convert(reader);
        }
        catch (Throwable throwable) {
            CommonUtils.closeQuietly(reader);
            throw throwable;
        }
        CommonUtils.closeQuietly(reader);
        return byArray;
    }
}

