/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.persistence;

import android.content.Context;
import android.os.Environment;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.File;

public class FileStoreImpl
implements FileStore {
    public static final String FILES_PATH = ".com.google.firebase.crashlytics";
    private final Context context;

    public FileStoreImpl(Context context) {
        this.context = context;
    }

    @Override
    public File getFilesDir() {
        return this.prepare(new File(this.context.getFilesDir(), FILES_PATH));
    }

    @Override
    public String getFilesDirPath() {
        return new File(this.context.getFilesDir(), FILES_PATH).getPath();
    }

    File prepare(File file) {
        if (file != null) {
            if (file.exists() || file.mkdirs()) {
                return file;
            }
            Logger.getLogger().w("FirebaseCrashlytics", "Couldn't create file");
        } else {
            Logger.getLogger().d("FirebaseCrashlytics", "Null File");
        }
        return null;
    }

    boolean isExternalStorageAvailable() {
        String state = Environment.getExternalStorageState();
        if (!"mounted".equals(state)) {
            Logger.getLogger().w("FirebaseCrashlytics", "External Storage is not mounted and/or writable\nHave you declared android.permission.WRITE_EXTERNAL_STORAGE in the manifest?");
            return false;
        }
        return true;
    }
}

