/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import com.google.android.gms.tasks.Task;
import com.google.firebase.crashlytics.core.UserMetadata;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CrashlyticsLifecycleEvents;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportDataCapture;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator$$Lambda$1;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator$$Lambda$2;
import com.google.firebase.crashlytics.internal.log.LogFileManager;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.send.DataTransportCrashlyticsReportSender;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class SessionReportingCoordinator
implements CrashlyticsLifecycleEvents {
    private static final String EVENT_TYPE_CRASH = "crash";
    private static final String EVENT_TYPE_LOGGED = "error";
    private static final int EVENT_THREAD_IMPORTANCE = 4;
    private static final int MAX_CHAINED_EXCEPTION_DEPTH = 8;
    private static final int DEFAULT_MAX_EVENTS_TO_KEEP = 8;
    private static final int DEFAULT_MAX_REPORTS_TO_KEEP = 4;
    private static final int DEFAULT_MAX_SESSIONS_TO_KEEP = 8;
    private final CrashlyticsReportDataCapture dataCapture;
    private final CrashlyticsReportPersistence reportPersistence;
    private final DataTransportCrashlyticsReportSender reportsSender;
    private final LogFileManager logFileManager;
    private final UserMetadata reportMetadata;
    private String currentSessionId;

    public static SessionReportingCoordinator create(Context context, IdManager idManager, FileStore fileStore, AppData appData, LogFileManager logFileManager, UserMetadata userMetadata, StackTraceTrimmingStrategy stackTraceTrimmingStrategy) {
        File rootFilesDirectory = new File(fileStore.getFilesDirPath());
        CrashlyticsReportDataCapture dataCapture = new CrashlyticsReportDataCapture(context, idManager, appData, stackTraceTrimmingStrategy);
        CrashlyticsReportPersistence reportPersistence = new CrashlyticsReportPersistence(rootFilesDirectory, 8, 4, 8);
        DataTransportCrashlyticsReportSender reportSender = DataTransportCrashlyticsReportSender.create(context);
        return new SessionReportingCoordinator(dataCapture, reportPersistence, reportSender, logFileManager, userMetadata);
    }

    SessionReportingCoordinator(CrashlyticsReportDataCapture dataCapture, CrashlyticsReportPersistence reportPersistence, DataTransportCrashlyticsReportSender reportsSender, LogFileManager logFileManager, UserMetadata reportMetadata) {
        this.dataCapture = dataCapture;
        this.reportPersistence = reportPersistence;
        this.reportsSender = reportsSender;
        this.logFileManager = logFileManager;
        this.reportMetadata = reportMetadata;
    }

    @Override
    public void onBeginSession(String sessionId, long timestamp) {
        this.currentSessionId = sessionId;
        CrashlyticsReport capturedReport = this.dataCapture.captureReportData(sessionId, timestamp);
        this.reportPersistence.persistReport(capturedReport);
    }

    @Override
    public void onLog(long timestamp, String log) {
        this.logFileManager.writeToLog(timestamp, log);
    }

    @Override
    public void onCustomKey(String key, String value) {
        this.reportMetadata.setCustomKey(key, value);
    }

    @Override
    public void onUserId(String userId) {
        this.reportMetadata.setUserId(userId);
    }

    @Override
    public void onEndSession() {
        this.currentSessionId = null;
    }

    public void persistFatalEvent(Throwable event, Thread thread, long timestamp) {
        this.persistEvent(event, thread, EVENT_TYPE_CRASH, timestamp, true);
    }

    public void persistNonFatalEvent(Throwable event, Thread thread, long timestamp) {
        this.persistEvent(event, thread, EVENT_TYPE_LOGGED, timestamp, false);
    }

    public void persistUserId() {
        this.reportPersistence.persistUserIdForSession(this.reportMetadata.getUserId(), this.currentSessionId);
    }

    public void finalizeSessions() {
        this.reportPersistence.finalizeReports(this.currentSessionId);
    }

    public void removeAllReports() {
        this.reportPersistence.deleteAllReports();
    }

    public void sendReports(String organizationId, Executor reportSendCompleteExecutor, SendReportPredicate sendReportPredicate) {
        if (!sendReportPredicate.shouldSendViaDataTransport()) {
            Logger.getLogger().d("FirebaseCrashlytics", "Send via DataTransport disabled. Removing reports.");
            this.reportPersistence.deleteAllReports();
            return;
        }
        List<CrashlyticsReport> reportsToSend = this.reportPersistence.loadFinalizedReports();
        for (CrashlyticsReport report : reportsToSend) {
            this.reportsSender.sendReport(report.withOrganizationId(organizationId)).continueWith(reportSendCompleteExecutor, SessionReportingCoordinator$$Lambda$1.lambdaFactory$(this));
        }
    }

    private void persistEvent(Throwable event, Thread thread, String eventType, long timestamp, boolean includeAllThreads) {
        boolean isHighPriority = eventType.equals(EVENT_TYPE_CRASH);
        CrashlyticsReport.Session.Event capturedEvent = this.dataCapture.captureEventData(event, thread, eventType, timestamp, 4, 8, includeAllThreads);
        CrashlyticsReport.Session.Event.Builder eventBuilder = capturedEvent.toBuilder();
        String content = this.logFileManager.getLogString();
        if (content != null) {
            eventBuilder.setLog(CrashlyticsReport.Session.Event.Log.builder().setContent(content).build());
        } else {
            Logger.getLogger().d("FirebaseCrashlytics", "No log data to include with this event.");
        }
        List<CrashlyticsReport.CustomAttribute> sortedCustomAttributes = SessionReportingCoordinator.getSortedCustomAttributes(this.reportMetadata.getCustomKeys());
        if (sortedCustomAttributes != null) {
            eventBuilder.setApp(capturedEvent.getApp().toBuilder().setCustomAttributes(ImmutableList.from(sortedCustomAttributes)).build());
        }
        this.reportPersistence.persistEvent(eventBuilder.build(), this.currentSessionId, isHighPriority);
    }

    private boolean onReportSendComplete(Task<CrashlyticsReport> task) {
        if (task.isSuccessful()) {
            CrashlyticsReport report = (CrashlyticsReport)task.getResult();
            String reportId = report.getSession().getIdentifier();
            Logger.getLogger().i("FirebaseCrashlytics", "Crashlytics report sent successfully: " + reportId);
            this.reportPersistence.deleteFinalizedReport(reportId);
            return true;
        }
        return false;
    }

    private static List<CrashlyticsReport.CustomAttribute> getSortedCustomAttributes(Map<String, String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return null;
        }
        ArrayList<CrashlyticsReport.CustomAttribute> attributesList = new ArrayList<CrashlyticsReport.CustomAttribute>();
        attributesList.ensureCapacity(attributes.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributesList.add(CrashlyticsReport.CustomAttribute.builder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        Collections.sort(attributesList, SessionReportingCoordinator$$Lambda$2.lambdaFactory$());
        return attributesList;
    }

    static /* synthetic */ int lambda$getSortedCustomAttributes$0(CrashlyticsReport.CustomAttribute attr1, CrashlyticsReport.CustomAttribute attr2) {
        return attr1.getKey().compareTo(attr2.getKey());
    }

    static /* synthetic */ boolean access$lambda$0(SessionReportingCoordinator sessionReportingCoordinator, Task task) {
        return sessionReportingCoordinator.onReportSendComplete((Task<CrashlyticsReport>)task);
    }

    public static interface SendReportPredicate {
        public boolean shouldSendViaDataTransport();
    }
}

