/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle.tasks;

import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.SourceDirectories;
import com.android.build.api.variant.Variant;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsBuildtools;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsPlugin;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsVariantExtension;
import com.google.firebase.crashlytics.buildtools.gradle.extensions.StringExtensionsKt;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.InjectMappingFileIdTask;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask;", "Lorg/gradle/api/DefaultTask;", "()V", "mappingFileIdFile", "Lorg/gradle/api/file/RegularFileProperty;", "getMappingFileIdFile", "()Lorg/gradle/api/file/RegularFileProperty;", "resourceDir", "Lorg/gradle/api/file/DirectoryProperty;", "getResourceDir", "()Lorg/gradle/api/file/DirectoryProperty;", "useBlankMappingFileId", "Lorg/gradle/api/provider/Property;", "", "getUseBlankMappingFileId", "()Lorg/gradle/api/provider/Property;", "blankMappingFileIdExists", "injectMappingFileId", "", "Companion", "crashlytics-gradle"})
public abstract class InjectMappingFileIdTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public InjectMappingFileIdTask() {
        this.setGroup("Firebase Crashlytics");
        this.setDescription("Generates and injects a mapping file id into the app, used by Crashlytics for deobfuscation.");
    }

    @Internal
    @NotNull
    public abstract Property<Boolean> getUseBlankMappingFileId();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getMappingFileIdFile();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResourceDir();

    @TaskAction
    public final void injectMappingFileId() {
        Object object = this.getUseBlankMappingFileId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"useBlankMappingFileId.get()");
        String mappingFileId = (Boolean)object != false ? "00000000000000000000000000000000" : CrashlyticsBuildtools.INSTANCE.generateMappingFileId();
        File file = ((RegularFile)this.getMappingFileIdFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"mappingFileIdFile.get().asFile");
        FilesKt.writeText$default((File)file, (String)mappingFileId, null, (int)2, null);
        CrashlyticsBuildtools.INSTANCE.injectMappingFileIdIntoResource(new File(((Directory)this.getResourceDir().get()).getAsFile(), "values/com_google_firebase_crashlytics_mappingfileid.xml"), mappingFileId);
    }

    private final boolean blankMappingFileIdExists() {
        File file = ((RegularFile)this.getMappingFileIdFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"mappingFileIdFile.get().asFile");
        File file2 = file;
        return file2.exists() && Intrinsics.areEqual((Object)FilesKt.readText$default((File)file2, null, (int)1, null), (Object)"00000000000000000000000000000000");
    }

    public static final /* synthetic */ boolean access$blankMappingFileIdExists(InjectMappingFileIdTask $this) {
        return $this.blankMappingFileIdExists();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask$Companion;", "", "()V", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/ApplicationVariant;", "crashlyticsExtension", "Lcom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsVariantExtension;", "crashlytics-gradle"})
    @SourceDebugExtension(value={"SMAP\nInjectMappingFileIdTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectMappingFileIdTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask$Companion\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,105:1\n254#2:106\n*S KotlinDebug\n*F\n+ 1 InjectMappingFileIdTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask$Companion\n*L\n84#1:106\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<InjectMappingFileIdTask> register(@NotNull Project project, @NotNull ApplicationVariant variant, @NotNull CrashlyticsVariantExtension crashlyticsExtension) {
            TaskProvider injectMappingFileIdTaskProvider2;
            block0: {
                void name$iv;
                void $this$register$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                Intrinsics.checkNotNullParameter((Object)crashlyticsExtension, (String)"crashlyticsExtension");
                TaskContainer taskContainer = project.getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                TaskContainer taskContainer2 = taskContainer;
                String string = "injectCrashlyticsMappingFileId" + StringExtensionsKt.capitalized(variant.getName());
                Function1 configuration$iv = (Function1)new Function1<InjectMappingFileIdTask, Unit>(crashlyticsExtension, variant, project){
                    final /* synthetic */ CrashlyticsVariantExtension $crashlyticsExtension;
                    final /* synthetic */ ApplicationVariant $variant;
                    final /* synthetic */ Project $project;
                    {
                        this.$crashlyticsExtension = $crashlyticsExtension;
                        this.$variant = $variant;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull InjectMappingFileIdTask $this$register) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                        $this$register.getUseBlankMappingFileId().set((Object)((Boolean)this.$crashlyticsExtension.getMappingFileUploadEnabled().getOrElse((Object)this.$variant.isMinifyEnabled()) == false ? 1 : 0));
                        $this$register.getMappingFileIdFile().set(CrashlyticsPlugin.Companion.buildFile(this.$project, (Variant)this.$variant, "mappingFileId.txt"));
                        $this$register.getOutputs().upToDateWhen(arg_0 -> register.injectMappingFileIdTaskProvider.1.invoke$lambda$0((Function1)new Function1<Task, Boolean>($this$register){
                            final /* synthetic */ InjectMappingFileIdTask $this_register;
                            {
                                this.$this_register = $this_register;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(Task it) {
                                Object object = this.$this_register.getUseBlankMappingFileId().get();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"useBlankMappingFileId.get()");
                                return (Boolean)object != false && InjectMappingFileIdTask.access$blankMappingFileIdExists(this.$this_register);
                            }
                        }, arg_0));
                    }

                    private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Boolean)$tmp0.invoke(p0);
                    }
                };
                boolean $i$f$register = false;
                Function1 function1 = configuration$iv;
                TaskProvider taskProvider = $this$register$iv.register((String)name$iv, InjectMappingFileIdTask.class, new Action(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ void execute(Object p0) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
                injectMappingFileIdTaskProvider2 = taskProvider;
                SourceDirectories.Layered layered = variant.getSources().getRes();
                if (layered == null) break block0;
                layered.addGeneratedSourceDirectory(injectMappingFileIdTaskProvider2, (Function1)register.1.INSTANCE);
            }
            return injectMappingFileIdTaskProvider2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

