/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static final String GZIPPED_FILE_SUFFIX = ".gz";
    public static final String[] FILE_EXTENSIONS = new String[]{"so"};

    public static void verifyDirectory(File path) throws IOException {
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!path.exists() || !path.isDirectory()) {
            throw new IOException("Could not create directory: " + path);
        }
    }

    public static void redirect(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
    }

    public static void gZipFile(File inputFile, File gZipOutputFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
             GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(gZipOutputFile));){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    public static boolean isZipFile(File path) {
        return path.exists() && path.isFile() && path.getName().toLowerCase().endsWith(".zip");
    }

    public static void unzipArchive(File archive, File outputDir) throws IOException {
        ZipFile zf = new ZipFile(archive);
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            FileUtils.unzipEntry(zf, entry, outputDir);
        }
    }

    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            FileUtils.verifyDirectory(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            FileUtils.verifyDirectory(outputFile.getParentFile());
        }
        BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStreamToFile(InputStream source, File dest) throws IOException {
        if (!dest.exists()) {
            dest.createNewFile();
        }
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(source));
            writer = new PrintWriter(dest, "UTF-8");
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static Collection<File> listFiles(File dir) {
        return org.apache.commons.io.FileUtils.listFiles((File)dir, (String[])FILE_EXTENSIONS, (boolean)true);
    }
}

